/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

public class Environment {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String ARCH = System.getProperty("os.arch").toLowerCase();

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static boolean is64Bit() {
        return ARCH.indexOf("64") > 0;
    }

    public static String getSharedLibraryName(String string) {
        return string + "jni";
    }

    public static String getSharedLibraryFileName(String string) {
        return Environment.appendLibOsSuffix("lib" + Environment.getSharedLibraryName(string), true);
    }

    public static String getJniLibraryName(String string) {
        if (Environment.isUnix()) {
            String string2 = Environment.is64Bit() ? "64" : "32";
            return String.format("%sjni-linux%s", string, string2);
        }
        if (Environment.isMac()) {
            return String.format("%sjni-osx", string);
        }
        if (Environment.isSolaris()) {
            return String.format("%sjni-solaris%d", string, Environment.is64Bit() ? 64 : 32);
        }
        if (Environment.isWindows() && Environment.is64Bit()) {
            return String.format("%sjni-win64", string);
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryFileName(String string) {
        return Environment.appendLibOsSuffix("lib" + Environment.getJniLibraryName(string), false);
    }

    private static String appendLibOsSuffix(String string, boolean bl) {
        if (Environment.isUnix() || Environment.isSolaris()) {
            return string + ".so";
        }
        if (Environment.isMac()) {
            return string + (bl ? ".dylib" : ".jnilib");
        }
        if (Environment.isWindows()) {
            return string + ".dll";
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryExtension() {
        if (Environment.isWindows()) {
            return ".dll";
        }
        return Environment.isMac() ? ".jnilib" : ".so";
    }
}

