/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import net.jcip.annotations.Immutable;

@Immutable
public class Version {
    private static final String MODULE_PREFIX = "ispn";
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int PATCH_MASK = 63;
    public static final String PROJECT_NAME = "Infinispan";
    private static final Version INSTANCE = new Version();
    private final String version;
    private final String codename;
    private final byte[] versionId;
    private final String moduleSlot;
    private final short versionShort;
    private final short marshallVersion;
    private final String majorMinor;
    private final String major;

    private Version() {
        Properties properties = new Properties();
        try (InputStream is2 = Version.class.getResourceAsStream("/META-INF/infinispan-version.properties");){
            properties.load(is2);
        }
        catch (Exception is2) {
            // empty catch block
        }
        this.version = properties.getProperty("infinispan.version", "0.0.0-SNAPSHOT");
        this.codename = properties.getProperty("infinispan.codename", "N/A");
        String[] parts = Version.getParts(this.version);
        this.versionId = Version.readVersionBytes(parts[0], parts[1], parts[2], parts[3]);
        this.versionShort = Version.getVersionShort(this.version);
        this.moduleSlot = String.format("%s-%s.%s", MODULE_PREFIX, parts[0], parts[1]);
        this.marshallVersion = Short.valueOf(parts[0] + parts[1]);
        this.majorMinor = String.format("%s.%s", parts[0], parts[1]);
        this.major = parts[0];
    }

    public static String getVersion() {
        return Version.INSTANCE.version;
    }

    public static String getCodename() {
        return Version.INSTANCE.codename;
    }

    public static String getModuleSlot() {
        return Version.INSTANCE.moduleSlot;
    }

    public static short getMarshallVersion() {
        return Version.INSTANCE.marshallVersion;
    }

    public static String getMajorMinor() {
        return Version.INSTANCE.majorMinor;
    }

    public static String getMajor() {
        return Version.INSTANCE.major;
    }

    public static boolean compareTo(byte[] v) {
        return Arrays.equals(Version.INSTANCE.versionId, v);
    }

    public static short getVersionShort() {
        return Version.INSTANCE.versionShort;
    }

    public static short getVersionShort(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        String[] parts = Version.getParts(versionString);
        int a = 0;
        int b = 0;
        int c = 0;
        if (parts.length > 0) {
            a = Integer.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            b = Integer.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            c = Integer.parseInt(parts[2]);
        }
        return Version.encodeVersion(a, b, c);
    }

    private static short encodeVersion(int major, int minor, int patch) {
        return (short)((major << 11) + (minor << 6) + patch);
    }

    public static String decodeVersion(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int patch = version & 0x3F;
        return major + "." + minor + "." + patch;
    }

    public static String decodeVersionForSerialization(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        return major + "." + minor;
    }

    public static void main(String[] args) {
        Version.printFullVersionInformation();
    }

    public static void printFullVersionInformation() {
        System.out.println(PROJECT_NAME);
        System.out.println();
        System.out.printf("Version: \t%s%n", Version.INSTANCE.version);
        System.out.printf("Codename: \t%s%n", Version.INSTANCE.codename);
        System.out.println("History: \t(see https://jira.jboss.org/jira/browse/ISPN for details)");
        System.out.println();
    }

    public static String printVersion() {
        return "Infinispan '" + Version.INSTANCE.codename + "' " + Version.INSTANCE.version;
    }

    private static byte[] readVersionBytes(String major, String minor, String micro, String modifier) {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < major.length(); ++i) {
            baos.write(major.charAt(i));
        }
        for (i = 0; i < minor.length(); ++i) {
            baos.write(minor.charAt(i));
        }
        for (i = 0; i < micro.length(); ++i) {
            baos.write(micro.charAt(i));
        }
        if ("SNAPSHOT".equals(modifier)) {
            baos.write(83);
        } else {
            for (i = 0; i < modifier.length(); ++i) {
                baos.write(modifier.charAt(i));
            }
        }
        return baos.toByteArray();
    }

    private static String[] getParts(String version) {
        return version.split("[\\.\\-]");
    }
}

