/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingUtils;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.util.function.RemovableFunction;

public class EncoderValueMapper<V>
implements RemovableFunction<V, V> {
    private final Class<? extends Encoder> valueEncoderClass;
    private final Class<? extends Wrapper> valueWrapperClass;
    private transient Encoder valueEncoder;
    private transient Wrapper valueWrapper;

    public EncoderValueMapper(Class<? extends Encoder> valueEncoderClass, Class<? extends Wrapper> valueWrapperClass) {
        this.valueEncoderClass = valueEncoderClass;
        this.valueWrapperClass = valueWrapperClass;
    }

    @Inject
    public void injectDependencies(EncoderRegistry encoderRegistry) {
        this.valueEncoder = encoderRegistry.getEncoder(this.valueEncoderClass);
        this.valueWrapper = encoderRegistry.getWrapper(this.valueWrapperClass);
    }

    @Override
    public V apply(V v) {
        return (V)EncodingUtils.fromStorage(v, this.valueEncoder, this.valueWrapper);
    }

    public static class Externalizer
    implements AdvancedExternalizer<EncoderValueMapper> {
        @Override
        public Set<Class<? extends EncoderValueMapper>> getTypeClasses() {
            return Collections.singleton(EncoderValueMapper.class);
        }

        @Override
        public Integer getId() {
            return 123;
        }

        @Override
        public void writeObject(ObjectOutput output, EncoderValueMapper object) throws IOException {
            output.writeObject(object.valueEncoderClass);
            output.writeObject(object.valueWrapperClass);
        }

        @Override
        public EncoderValueMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EncoderValueMapper((Class)input.readObject(), (Class)input.readObject());
        }
    }
}

