/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;

public class HeaderParams {
    short opCode;
    short opRespCode;
    byte[] cacheName;
    int flags;
    byte clientIntel;
    byte txMarker;
    AtomicInteger topologyId;
    long messageId;
    int topologyAge;

    public HeaderParams opCode(short opCode) {
        this.opCode = opCode;
        this.opRespCode = this.toOpRespCode(opCode);
        return this;
    }

    public HeaderParams cacheName(byte[] cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public HeaderParams flags(int flags) {
        this.flags = flags;
        return this;
    }

    public HeaderParams clientIntel(ClientIntelligence clientIntel) {
        this.clientIntel = clientIntel.getValue();
        return this;
    }

    public HeaderParams txMarker(byte txMarker) {
        this.txMarker = txMarker;
        return this;
    }

    public HeaderParams topologyId(AtomicInteger topologyId) {
        this.topologyId = topologyId;
        return this;
    }

    public HeaderParams messageId(long messageId) {
        this.messageId = messageId;
        return this;
    }

    public HeaderParams topologyAge(int topologyAge) {
        this.topologyAge = topologyAge;
        return this;
    }

    private short toOpRespCode(short opCode) {
        switch (opCode) {
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 7: {
                return 8;
            }
            case 9: {
                return 10;
            }
            case 11: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 15: {
                return 16;
            }
            case 17: {
                return 18;
            }
            case 19: {
                return 20;
            }
            case 21: {
                return 22;
            }
            case 23: {
                return 24;
            }
            case 25: {
                return 26;
            }
            case 27: {
                return 28;
            }
            case 29: {
                return 30;
            }
            case 31: {
                return 32;
            }
            case 33: {
                return 34;
            }
            case 35: {
                return 36;
            }
            case 37: {
                return 38;
            }
            case 39: {
                return 40;
            }
            case 41: {
                return 42;
            }
            case 43: {
                return 44;
            }
            case 45: {
                return 46;
            }
            case 47: {
                return 48;
            }
            case 49: {
                return 50;
            }
            case 51: {
                return 52;
            }
            case 53: {
                return 54;
            }
            case 55: {
                return 56;
            }
            case 57: {
                return 58;
            }
        }
        throw new IllegalStateException("Unknown operation code: " + opCode);
    }

    static int joinFlags(Flag[] flags) {
        int flagInt = 0;
        if (flags != null) {
            for (Flag flag : flags) {
                flagInt = flag.getFlagInt() | flagInt;
            }
        }
        return flagInt;
    }
}

