/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

public class ExceptionAckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 42;
    private CommandAckCollector commandAckCollector;
    private Throwable throwable;
    private long id;
    private int topologyId;

    public ExceptionAckCommand() {
        super(null);
    }

    public ExceptionAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public ExceptionAckCommand(ByteString cacheName, long id, Throwable throwable, int topologyId) {
        super(cacheName);
        this.id = id;
        this.throwable = throwable;
        this.topologyId = topologyId;
    }

    public void ack() {
        this.commandAckCollector.completeExceptionally(this.id, this.throwable, this.topologyId);
    }

    @Override
    public byte getCommandId() {
        return 42;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.id);
        output.writeObject(this.throwable);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readLong();
        this.throwable = (Throwable)input.readObject();
        this.topologyId = input.readInt();
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    @Override
    public String toString() {
        return "ExceptionAckCommand{id=" + this.id + ", throwable=" + this.throwable + ", topologyId=" + this.topologyId + '}';
    }
}

