/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compat;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingUtils;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.EncoderRegistry;

public class FunctionMapper
implements Function {
    private final Class<? extends Encoder> keyEncoderClass;
    private final Class<? extends Encoder> valueEncoderClass;
    private final Class<? extends Wrapper> keyWrapperClass;
    private final Class<? extends Wrapper> valueWrapperClass;
    private Encoder keyEncoder;
    private Encoder valueEncoder;
    private Wrapper keyWrapper;
    private Wrapper valueWrapper;
    private final Function function;

    @Inject
    public void injectDependencies(EncoderRegistry encoderRegistry) {
        this.keyEncoder = encoderRegistry.getEncoder(this.keyEncoderClass);
        this.valueEncoder = encoderRegistry.getEncoder(this.valueEncoderClass);
        this.keyWrapper = encoderRegistry.getWrapper(this.keyWrapperClass);
        this.valueWrapper = encoderRegistry.getWrapper(this.valueWrapperClass);
    }

    public FunctionMapper(Function mappingFunction, Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass, Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        this.function = mappingFunction;
        this.keyEncoderClass = keyEncoderClass;
        this.valueEncoderClass = valueEncoderClass;
        this.keyWrapperClass = keyWrapperClass;
        this.valueWrapperClass = valueWrapperClass;
    }

    public Object apply(Object k) {
        Object key = EncodingUtils.fromStorage(k, this.keyEncoder, this.keyWrapper);
        Object result = this.function.apply(key);
        return result != null ? EncodingUtils.toStorage(result, this.valueEncoder, this.valueWrapper) : null;
    }

    public static class Externalizer
    implements AdvancedExternalizer<FunctionMapper> {
        @Override
        public Set<Class<? extends FunctionMapper>> getTypeClasses() {
            return Collections.singleton(FunctionMapper.class);
        }

        @Override
        public Integer getId() {
            return 125;
        }

        @Override
        public void writeObject(ObjectOutput output, FunctionMapper object) throws IOException {
            output.writeObject(object.function);
            output.writeObject(object.keyEncoderClass);
            output.writeObject(object.valueEncoderClass);
            output.writeObject(object.keyWrapperClass);
            output.writeObject(object.valueWrapperClass);
        }

        @Override
        public FunctionMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new FunctionMapper((Function)input.readObject(), (Class)input.readObject(), (Class)input.readObject(), (Class)input.readObject(), (Class)input.readObject());
        }
    }
}

