/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicatedConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash> {
    private static final Log log = LogFactory.getLog(ReplicatedConsistentHashFactory.class);

    @Override
    public ReplicatedConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        int[] primaryOwners = new int[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            primaryOwners[i] = i % members.size();
        }
        return new ReplicatedConsistentHash(hashFunction, members, primaryOwners);
    }

    @Override
    public ReplicatedConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!ReplicatedConsistentHash.class.getName().equals(consistentHashClass)) {
            throw log.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new ReplicatedConsistentHash(state);
    }

    @Override
    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> actualCapacityFactors) {
        if (newMembers.equals(baseCH.getMembers())) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int[] primaryOwners = new int[numSegments];
        int[] nodeUsage = new int[newMembers.size()];
        boolean foundOrphanSegments = false;
        for (int segmentId = 0; segmentId < numSegments; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = baseCH.locatePrimaryOwnerForSegment(segmentId);
            primaryOwners[segmentId] = primaryOwnerIndex = newMembers.indexOf(primaryOwner);
            if (primaryOwnerIndex == -1) {
                foundOrphanSegments = true;
                continue;
            }
            int n = primaryOwnerIndex;
            nodeUsage[n] = nodeUsage[n] + 1;
        }
        if (foundOrphanSegments) {
            for (int i = 0; i < numSegments; ++i) {
                int leastUsed;
                if (primaryOwners[i] != -1) continue;
                primaryOwners[i] = leastUsed = this.findLeastUsedNode(nodeUsage);
                int n = leastUsed;
                nodeUsage[n] = nodeUsage[n] + 1;
            }
        }
        int minSegmentsPerNode = numSegments / newMembers.size();
        Queue[] segmentsByNode = new Queue[newMembers.size()];
        for (int segmentId = 0; segmentId < primaryOwners.length; ++segmentId) {
            int owner = primaryOwners[segmentId];
            ArrayDeque<Integer> segments = segmentsByNode[owner];
            if (segments == null) {
                segmentsByNode[owner] = segments = new ArrayDeque<Integer>(minSegmentsPerNode);
            }
            segments.add(segmentId);
        }
        int mostUsedNode = 0;
        for (int node = 0; node < nodeUsage.length; ++node) {
            while (nodeUsage[node] < minSegmentsPerNode) {
                if (nodeUsage[mostUsedNode] <= minSegmentsPerNode + 1) {
                    mostUsedNode = this.findMostUsedNode(nodeUsage);
                }
                int segmentId = (Integer)segmentsByNode[mostUsedNode].poll();
                primaryOwners[segmentId] = node;
                int n = mostUsedNode;
                nodeUsage[n] = nodeUsage[n] - 1;
                int n2 = node;
                nodeUsage[n2] = nodeUsage[n2] + 1;
            }
        }
        return new ReplicatedConsistentHash(baseCH.getHashFunction(), newMembers, primaryOwners);
    }

    private int findLeastUsedNode(int[] nodeUsage) {
        int res = 0;
        for (int node = 1; node < nodeUsage.length; ++node) {
            if (nodeUsage[node] >= nodeUsage[res]) continue;
            res = node;
        }
        return res;
    }

    private int findMostUsedNode(int[] nodeUsage) {
        int res = 0;
        for (int node = 1; node < nodeUsage.length; ++node) {
            if (nodeUsage[node] <= nodeUsage[res]) continue;
            res = node;
        }
        return res;
    }

    @Override
    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        return baseCH;
    }

    @Override
    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        return ch1.union(ch2);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public int hashCode() {
        return -6053;
    }

    public static class Externalizer
    extends AbstractExternalizer<ReplicatedConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, ReplicatedConsistentHashFactory chf) {
        }

        @Override
        public ReplicatedConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new ReplicatedConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 51;
        }

        @Override
        public Set<Class<? extends ReplicatedConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHashFactory.class);
        }
    }
}

