/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.HashSet;
import java.util.Map;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(PartitionHandlingInterceptor.class);
    private PartitionHandlingManager partitionHandlingManager;
    private InvocationFinallyAction handleDataReadReturn = this::handleDataReadReturn;
    private InvocationFinallyAction handleGetAllCommandReturn = this::handleGetAllCommandReturn;
    private InvocationSuccessAction postTxCommandCheck = this::postTxCommandCheck;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager) {
        this.partitionHandlingManager = partitionHandlingManager;
    }

    private boolean performPartitionCheck(InvocationContext ctx, FlagAffectedCommand command) {
        if (!ctx.isOriginLocal()) {
            return !command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
        }
        return !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected Object handleSingleWrite(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    private Object handleDataReadCommand(InvocationContext ctx, DataCommand command) {
        return this.invokeNextAndFinally(ctx, command, this.handleDataReadReturn);
    }

    private void handleDataReadReturn(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        DataCommand dataCommand = (DataCommand)rCommand;
        if (t != null) {
            if (t instanceof RpcException && this.performPartitionCheck(rCtx, dataCommand)) {
                throw log.degradedModeKeyUnavailable(dataCommand.getKey());
            }
            if (t instanceof AllOwnersLostException && this.performPartitionCheck(rCtx, dataCommand) && !this.cacheConfiguration.clustering().cacheMode().isScattered()) {
                throw log.degradedModeKeyUnavailable(dataCommand.getKey());
            }
        }
        if (this.performPartitionCheck(rCtx, dataCommand)) {
            this.partitionHandlingManager.checkRead(dataCommand.getKey());
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.postTxCommandCheck);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.postTxCommandCheck);
    }

    protected void postTxCommandCheck(InvocationContext rCtx, VisitableCommand rCommand, Object rv) {
        TxInvocationContext ctx = (TxInvocationContext)rCtx;
        if (ctx.hasModifications() && this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction())) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.handleGetAllCommandReturn);
    }

    private void handleGetAllCommandReturn(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        GetAllCommand getAllCommand = (GetAllCommand)rCommand;
        if (t != null && t instanceof RpcException && this.performPartitionCheck(rCtx, getAllCommand)) {
            throw log.degradedModeKeysUnavailable(((GetAllCommand)rCommand).getKeys());
        }
        if (this.performPartitionCheck(rCtx, getAllCommand)) {
            Map result;
            for (Object key : getAllCommand.getKeys()) {
                this.partitionHandlingManager.checkRead(key);
            }
            if (t == null && (result = (Map)rv).size() != getAllCommand.getKeys().size()) {
                HashSet missingKeys = new HashSet(getAllCommand.getKeys());
                missingKeys.removeAll(result.keySet());
                throw log.degradedModeKeysUnavailable(missingKeys);
            }
        }
    }
}

