/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.connectionfactory;

import java.sql.Connection;
import java.sql.SQLException;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.C3P0ConnectionPool;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionPool;
import org.infinispan.persistence.jdbc.connectionfactory.HikariConnectionPool;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class PooledConnectionFactory
extends ConnectionFactory {
    private static final Log log = LogFactory.getLog(PooledConnectionFactory.class, Log.class);
    private static boolean trace = log.isTraceEnabled();
    private ConnectionPool connectionPool;

    @Override
    public void start(ConnectionFactoryConfiguration config, ClassLoader classLoader) throws PersistenceException {
        if (!(config instanceof PooledConnectionFactoryConfiguration)) {
            throw new PersistenceException("ConnectionFactoryConfiguration passed in must be an instance of PooledConnectionFactoryConfiguration");
        }
        PooledConnectionFactoryConfiguration poolConfig = (PooledConnectionFactoryConfiguration)config;
        ConnectionPool connectionPool = this.connectionPool = C3P0ConnectionPool.forceC3P0() ? new C3P0ConnectionPool(classLoader, poolConfig) : new HikariConnectionPool(classLoader, poolConfig);
        if (trace) {
            log.tracef("Started connection factory with config: %s", (Object)config);
        }
    }

    @Override
    public void stop() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
            if (trace) {
                log.debug("Successfully stopped PooledConnectionFactory.");
            }
        }
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        try {
            this.logBefore(true);
            Connection connection = this.connectionPool.getConnection();
            this.logAfter(connection, true);
            return connection;
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed obtaining connection from PooledDataSource", e);
        }
    }

    @Override
    public void releaseConnection(Connection conn) {
        this.logBefore(false);
        JdbcUtil.safeClose(conn);
        this.logAfter(conn, false);
    }

    public int getMaxPoolSize() {
        return this.connectionPool.getMaxPoolSize();
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.connectionPool.getNumConnectionsAllUsers();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.connectionPool.getNumBusyConnectionsAllUsers();
    }

    private void logBefore(boolean checkout) {
        this.log(null, checkout, true);
    }

    private void logAfter(Connection connection, boolean checkout) {
        this.log(connection, checkout, false);
    }

    private void log(Connection connection, boolean checkout, boolean before) {
        if (trace) {
            String stage = before ? "before" : "after";
            String operation = checkout ? "checkout" : "release";
            try {
                log.tracef("DataSource %s %s (NumBusyConnectionsAllUsers) : %d, (NumConnectionsAllUsers) : %d", stage, operation, this.getNumBusyConnectionsAllUsers(), this.getNumConnectionsAllUsers());
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
            if (connection != null) {
                log.tracef("Connection %s : %s", (Object)operation, (Object)connection);
            }
        }
    }
}

