/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteString {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ByteString EMPTY = new ByteString(new byte[0]);
    private final byte[] b;
    private String s;
    private final transient int hash;

    private ByteString(byte[] b) {
        if (b.length > 127) {
            throw new IllegalArgumentException("ByteString must be shorter than 127 bytes");
        }
        this.b = b;
        this.hash = Arrays.hashCode(b);
    }

    public static ByteString fromString(String s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        return new ByteString(s.getBytes(CHARSET));
    }

    public static ByteString emptyString() {
        return EMPTY;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteString that = (ByteString)o;
        return Arrays.equals(this.b, that.b);
    }

    public String toString() {
        if (this.s == null) {
            this.s = new String(this.b, CHARSET);
        }
        return this.s;
    }

    public static void writeObject(ObjectOutput output, ByteString object) throws IOException {
        output.writeByte(object.b.length);
        if (object.b.length > 0) {
            output.write(object.b);
        }
    }

    public static ByteString readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        short len = input.readByte();
        if (len == 0) {
            return EMPTY;
        }
        byte[] b = new byte[len];
        input.readFully(b);
        return new ByteString(b);
    }
}

