/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.slf4j;

import org.jboss.logging.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class JBossLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger {
    private static final long serialVersionUID = -1855332334983449117L;
    final Logger logger;
    private static final String LOGGER_FQCN = JBossLoggerAdapter.class.getName();

    JBossLoggerAdapter(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void log(Marker marker, String fqcn, int level, String message, Object[] argArray, Throwable t) {
        FormattingTuple result = MessageFormatter.arrayFormat(message, argArray);
        switch (level) {
            case 0: {
                this.logger.trace(fqcn, result.getMessage(), t);
                break;
            }
            case 10: {
                this.logger.debug(fqcn, result.getMessage(), t);
                break;
            }
            case 20: {
                this.logger.info(fqcn, result.getMessage(), t);
                break;
            }
            case 30: {
                this.logger.warn(fqcn, result.getMessage(), t);
                break;
            }
            case 40: {
                this.logger.error(fqcn, result.getMessage(), t);
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + level + " is not recognized.");
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.log(Logger.Level.TRACE, LOGGER_FQCN, msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.logger.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
            this.log(Logger.Level.TRACE, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
            this.log(Logger.Level.TRACE, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this.log(Logger.Level.TRACE, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.log(Logger.Level.TRACE, LOGGER_FQCN, msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            this.log(Logger.Level.DEBUG, LOGGER_FQCN, msg, null);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
            this.log(Logger.Level.DEBUG, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
            this.log(Logger.Level.DEBUG, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this.log(Logger.Level.DEBUG, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.log(Logger.Level.DEBUG, LOGGER_FQCN, msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.logger.isInfoEnabled()) {
            this.log(Logger.Level.INFO, LOGGER_FQCN, msg, null);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
            this.log(Logger.Level.INFO, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
            this.log(Logger.Level.INFO, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this.log(Logger.Level.INFO, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.log(Logger.Level.INFO, LOGGER_FQCN, msg, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabled(Logger.Level.WARN);
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.log(Logger.Level.WARN, LOGGER_FQCN, msg, null);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
            this.log(Logger.Level.WARN, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this.log(Logger.Level.WARN, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
            this.log(Logger.Level.WARN, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(Logger.Level.WARN, LOGGER_FQCN, msg, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabled(Logger.Level.ERROR);
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.log(Logger.Level.ERROR, LOGGER_FQCN, msg, null);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
            this.log(Logger.Level.ERROR, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
            this.log(Logger.Level.ERROR, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this.log(Logger.Level.ERROR, LOGGER_FQCN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(Logger.Level.ERROR, LOGGER_FQCN, msg, t);
        }
    }

    private void log(Logger.Level level, String fqcn, Object message, Throwable t) {
        this.logger.log(level, fqcn, message, t);
    }
}

