/*
 * Decompiled with CFR 0.152.
 */
package protostream.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import protostream.javassist.ClassPool;
import protostream.javassist.bytecode.ConstPool;
import protostream.javassist.bytecode.annotation.AnnotationsWriter;
import protostream.javassist.bytecode.annotation.MemberValue;
import protostream.javassist.bytecode.annotation.MemberValueVisitor;

public class ByteMemberValue
extends MemberValue {
    int valueIndex;

    public ByteMemberValue(int index, ConstPool cp) {
        super('B', cp);
        this.valueIndex = index;
    }

    public ByteMemberValue(byte b, ConstPool cp) {
        super('B', cp);
        this.setValue(b);
    }

    public ByteMemberValue(ConstPool cp) {
        super('B', cp);
        this.setValue((byte)0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Byte(this.getValue());
    }

    @Override
    Class getType(ClassLoader cl) {
        return Byte.TYPE;
    }

    public byte getValue() {
        return (byte)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(byte newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Byte.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitByteMemberValue(this);
    }
}

