/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import java.util.Properties;
import javax.ejb.ScheduleExpression;
import org.jberet.schedule.JobScheduleConfig;

public final class JobScheduleConfigBuilder {
    private String jobName;
    private long jobExecutionId;
    private Properties jobParameters;
    private ScheduleExpression scheduleExpression;
    private long initialDelay;
    private long afterDelay;
    private long interval;
    private boolean persistent = true;

    private JobScheduleConfigBuilder() {
    }

    public static JobScheduleConfigBuilder newInstance() {
        return new JobScheduleConfigBuilder();
    }

    public JobScheduleConfig build() {
        return new JobScheduleConfig(this.jobName, this.jobExecutionId, this.jobParameters, this.scheduleExpression, this.initialDelay, this.afterDelay, this.interval, this.persistent);
    }

    public JobScheduleConfigBuilder jobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public JobScheduleConfigBuilder jobExecutionId(long jobExecutionId) {
        this.jobExecutionId = jobExecutionId;
        return this;
    }

    public JobScheduleConfigBuilder jobParameters(Properties jobParameters) {
        this.jobParameters = jobParameters;
        return this;
    }

    public JobScheduleConfigBuilder scheduleExpression(ScheduleExpression scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
        return this;
    }

    public JobScheduleConfigBuilder initialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
        return this;
    }

    public JobScheduleConfigBuilder afterDelay(long afterDelay) {
        this.afterDelay = afterDelay;
        return this;
    }

    public JobScheduleConfigBuilder interval(long interval) {
        this.interval = interval;
        return this;
    }

    public JobScheduleConfigBuilder persistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }
}

