/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.batch.api.BatchProperty;
import javax.batch.api.listener.AbstractJobListener;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduleConfigBuilder;
import org.jberet.schedule.JobScheduler;
import org.jberet.schedule._private.ScheduleExecutorLogger;

@Named
public class SchedulingJobListener
extends AbstractJobListener {
    private static final String numOfSchedulesKey = SchedulingJobListener.class.getName() + ".numOfSchedules";
    @Inject
    protected JobContext jobContext;
    @Inject
    @BatchProperty
    protected long initialDelay = 2L;
    @Inject
    @BatchProperty
    protected boolean persistent;
    @Inject
    @BatchProperty
    protected Date stopAfterTime;
    @Inject
    @BatchProperty
    protected Integer maxSchedules;
    @Inject
    @BatchProperty
    protected List<BatchStatus> onBatchStatus;
    @Inject
    @BatchProperty
    protected boolean restartFailedStopped = true;

    public void afterJob() {
        long executionId = this.jobContext.getExecutionId();
        try {
            JobExecution jobExecution = JobScheduler.getJobOperator().getJobExecution(executionId);
            BatchStatus currentStatus = this.jobContext.getBatchStatus();
            if (this.needToSchedule(jobExecution, currentStatus)) {
                Properties nextExecutionParams = this.getJobParameters(jobExecution);
                if (this.maxSchedules != null) {
                    String numValue;
                    Properties currentExecutionParams = jobExecution.getJobParameters();
                    int currentScheduleCount = 0;
                    if (currentExecutionParams != null && (numValue = currentExecutionParams.getProperty(numOfSchedulesKey)) != null) {
                        currentScheduleCount = Integer.parseInt(numValue);
                    }
                    nextExecutionParams.setProperty(numOfSchedulesKey, String.valueOf(currentScheduleCount + 1));
                }
                JobScheduler scheduler = JobScheduler.getJobScheduler();
                JobScheduleConfigBuilder builder = JobScheduleConfigBuilder.newInstance().initialDelay(this.initialDelay).persistent(this.persistent).jobParameters(nextExecutionParams);
                JobScheduleConfig scheduleConfig = (currentStatus == BatchStatus.FAILED || currentStatus == BatchStatus.STOPPED || currentStatus == BatchStatus.STOPPING) && this.isRestartFailedStopped() ? builder.jobExecutionId(executionId).build() : builder.jobName(this.jobContext.getJobName()).build();
                JobSchedule schedule = scheduler.schedule(scheduleConfig);
                ScheduleExecutorLogger.LOGGER.scheduledNextExecution(executionId, schedule.getId(), scheduleConfig);
            }
        }
        catch (Throwable th) {
            ScheduleExecutorLogger.LOGGER.failToSchedule(th, executionId);
        }
    }

    protected boolean needToSchedule(JobExecution jobExecution, BatchStatus currentStatus) {
        int num;
        String numValue;
        Properties jobParameters;
        if (this.initialDelay < 0L) {
            return false;
        }
        if (this.stopAfterTime != null && System.currentTimeMillis() >= this.stopAfterTime.getTime()) {
            return false;
        }
        if (this.maxSchedules != null && (jobParameters = jobExecution.getJobParameters()) != null && (numValue = jobParameters.getProperty(numOfSchedulesKey)) != null && (num = Integer.parseInt(numValue)) >= this.maxSchedules) {
            return false;
        }
        if (this.onBatchStatus != null && !this.onBatchStatus.isEmpty()) {
            if (currentStatus == BatchStatus.STARTED) {
                return this.onBatchStatus.contains(BatchStatus.COMPLETED) || this.onBatchStatus.contains(BatchStatus.STARTED);
            }
            if (currentStatus == BatchStatus.STOPPING) {
                return this.onBatchStatus.contains(BatchStatus.STOPPING) || this.onBatchStatus.contains(BatchStatus.STOPPED);
            }
            return this.onBatchStatus.contains(currentStatus);
        }
        return true;
    }

    protected boolean isRestartFailedStopped() {
        return this.restartFailedStopped;
    }

    protected Properties getJobParameters(JobExecution jobExecution) {
        Properties properties = new Properties();
        Properties currentExecutionParams = jobExecution.getJobParameters();
        if (currentExecutionParams != null) {
            properties.putAll((Map<?, ?>)currentExecutionParams);
        }
        return properties;
    }
}

