/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jboss.as.clustering.ClusterNode;
import org.jgroups.Address;

public class ClusterNodeImpl
implements ClusterNode {
    private static final long serialVersionUID = -1831036833785680731L;
    private final String id;
    private final Address jgAddress;
    private final InetSocketAddress socketAddress;

    ClusterNodeImpl(String id, Address jgAddress, InetSocketAddress socketAddress) {
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("Null addressPort");
        }
        this.id = id;
        this.socketAddress = socketAddress;
        this.jgAddress = jgAddress;
    }

    public String getName() {
        return this.id;
    }

    public InetAddress getIpAddress() {
        return this.socketAddress.getAddress();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    Address getOriginalJGAddress() {
        return this.jgAddress;
    }

    public int compareTo(ClusterNode o) {
        if (o == null) {
            throw new ClassCastException("Comparison to null value");
        }
        if (!(o instanceof ClusterNodeImpl)) {
            throw new ClassCastException("Comparison between different classes");
        }
        return this.id.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNodeImpl)) {
            return false;
        }
        ClusterNodeImpl other = (ClusterNodeImpl)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

