/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.deployers.processors.ParsedRaDeploymentProcessor;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.connector.util.Injection;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class RaXmlDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(110L);
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.raxmldeployer");
    private final InjectedValue<MetadataRepository> mdr = new InjectedValue();
    private final InjectedValue<TransactionManagerService> txm = new InjectedValue();
    private final InjectedValue<ConnectorSubsystemConfiguration> config = new InjectedValue();
    private final InjectedValue<ResourceAdapters> raxmlValue = new InjectedValue();
    private final InjectedValue<ResourceAdapterDeploymentRegistry> registry = new InjectedValue();
    private final InjectedValue<JndiStrategy> jndiStrategy = new InjectedValue();
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)context.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        ResourceAdapters raxmls = null;
        raxmls = (ResourceAdapters)this.raxmlValue.getValue();
        if (raxmls == null) {
            return;
        }
        log.tracef("processing Raxml", new Object[0]);
        Module module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for deployment: " + context.getName());
        }
        try {
            ModuleClassLoader classLoader = module.getClassLoader();
            BatchBuilder batchBuilder = context.getBatchBuilder();
            for (ResourceAdapter raxml : raxmls.getResourceAdapters()) {
                String archive = raxml.getArchive();
                URL deployment = null;
                Set deployments = ((MetadataRepository)this.mdr.getValue()).getResourceAdapters();
                for (String s : deployments) {
                    if (!s.endsWith(archive) && !s.endsWith(archive.substring(0, archive.indexOf(".rar")))) continue;
                    deployment = new URL(s);
                }
                if (deployment == null) continue;
                Connector cmd = ((MetadataRepository)this.mdr.getValue()).getResourceAdapter(deployment.toExternalForm());
                IronJacamar ijmd = ((MetadataRepository)this.mdr.getValue()).getIronJacamar(deployment.toExternalForm());
                File root = ((MetadataRepository)this.mdr.getValue()).getRoot(deployment.toExternalForm());
                cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)raxml, cmd);
                String deploymentName = archive.substring(0, archive.indexOf(".rar"));
                AS7RaDeployer raDeployer = new AS7RaDeployer();
                raDeployer.setConfiguration((Configuration)this.config.getValue());
                CommonDeployment raxmlDeployment = raDeployer.doDeploy(connectorXmlDescriptor.getUrl(), deploymentName, root, (ClassLoader)classLoader, cmd, ijmd, raxml);
                ResourceAdapterDeployment dply = new ResourceAdapterDeployment(module.getIdentifier(), raxmlDeployment);
                ResourceAdapterXmlDeploymentService service = new ResourceAdapterXmlDeploymentService(dply);
                batchBuilder.addService(ConnectorServices.RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{deploymentName}), (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, service.getRegistryInjector()).addDependency(ConnectorServices.JNDI_STRATEGY_SERVICE, JndiStrategy.class, service.getJndiInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
                ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(dply);
            }
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public Value<MetadataRepository> getMdr() {
        return this.mdr;
    }

    public Injector<ResourceAdapterDeploymentRegistry> getRegistryInjector() {
        return this.registry;
    }

    public Injector<JndiStrategy> getJndiInjector() {
        return this.jndiStrategy;
    }

    public Value<TransactionManagerService> getTxm() {
        return this.txm;
    }

    public Value<ConnectorSubsystemConfiguration> getConfig() {
        return this.config;
    }

    public Injector<ResourceAdapters> getRaxmlValueInjector() {
        return this.raxmlValue;
    }

    public Injector<MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<TransactionManagerService> getTxmInjector() {
        return this.txm;
    }

    public Injector<ConnectorSubsystemConfiguration> getConfigInjector() {
        return this.config;
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }

    private class AS7RaDeployer
    extends AbstractResourceAdapterDeployer {
        private String deploymentName;

        public AS7RaDeployer() {
            super(true, ParsedRaDeploymentProcessor.log);
        }

        public CommonDeployment doDeploy(URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd, ResourceAdapter ra) throws Throwable {
            this.setConfiguration((Configuration)RaXmlDeploymentProcessor.this.getConfig().getValue());
            this.deploymentName = deploymentName;
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(url, deploymentName, root, cl, cmd, ijmd, ra);
            return dep;
        }

        public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
            throw new IllegalStateException("Non-explicit JNDI bindings not supported");
        }

        public String[] bindConnectionFactory(URL url, String deployment, Object cf, String jndi) throws Throwable {
            JndiStrategy js = (JndiStrategy)RaXmlDeploymentProcessor.this.jndiStrategy.getValue();
            String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
            ((MetadataRepository)RaXmlDeploymentProcessor.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
            this.log.infof("Bound connection factory at %s", (Object)jndi);
            return result;
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao) throws Throwable {
            throw new IllegalStateException("Non-explicit JNDI bindings not supported");
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao, String jndi) throws Throwable {
            JndiStrategy js = (JndiStrategy)RaXmlDeploymentProcessor.this.jndiStrategy.getValue();
            String[] result = js.bindAdminObjects(deployment, new Object[]{ao}, new String[]{jndi});
            ((MetadataRepository)RaXmlDeploymentProcessor.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), jndi);
            this.log.infof("Bound admin object at %s", (Object)jndi);
            return result;
        }

        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            return true;
        }

        protected boolean checkConfigurationIsValid() {
            return this.getConfiguration() != null;
        }

        protected PrintWriter getLogPrintWriter() {
            return new PrintWriter(System.out);
        }

        protected File getReportDirectory() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TransactionManager getTransactionManager() {
            AccessController.doPrivileged(new SetContextLoaderAction(TransactionManagerService.class.getClassLoader()));
            try {
                TransactionManager transactionManager = ((TransactionManagerService)RaXmlDeploymentProcessor.this.getTxm().getValue()).getTransactionManager();
                return transactionManager;
            }
            finally {
                AccessController.doPrivileged(CLEAR_ACTION);
            }
        }

        public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        ConfigProperty16 cpmd16;
                        if (!configProperty.isValueSet()) continue;
                        boolean setValue = true;
                        if (configProperty instanceof ConfigProperty16 && (cpmd16 = (ConfigProperty16)configProperty).getConfigPropertyIgnore() != null && cpmd16.getConfigPropertyIgnore().booleanValue()) {
                            setValue = false;
                        }
                        if (!setValue) continue;
                        injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw new DeployException("Deployment " + className + " failed", t);
            }
        }

        protected void registerResourceAdapterToMDR(URL url, File file, Connector connector, IronJacamar ij) throws AlreadyExistsException {
            this.log.debugf("Registering ResourceAdapter %s", (Object)this.deploymentName);
            ((MetadataRepository)RaXmlDeploymentProcessor.this.mdr.getValue()).registerResourceAdapter(this.deploymentName, file, connector, ij);
        }
    }
}

