/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.util.concurrent.Executor;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.bootstrap.DefaultBootStrapContextService;
import org.jboss.as.connector.deployers.RaDeploymentActivator;
import org.jboss.as.connector.subsystems.connector.ConnectorConfigService;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemElement;
import org.jboss.as.connector.subsystems.connector.Namespace;
import org.jboss.as.connector.workmanager.WorkManagerService;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.TxnServices;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.bootstrapcontext.BaseCloneableBootstrapContext;
import org.jboss.jca.core.workmanager.WorkManagerImpl;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.tm.JBossXATerminator;

public final class ConnectorSubsystemAdd
extends AbstractSubsystemAdd<ConnectorSubsystemElement> {
    private static final long serialVersionUID = -874698675049495644L;
    private boolean archiveValidation = true;
    private boolean archiveValidationFailOnError = true;
    private boolean archiveValidationFailOnWarn = false;
    private boolean beanValidation = true;
    private String shortRunningThreadPool = null;
    private String longRunningThreadPool = null;

    protected ConnectorSubsystemAdd() {
        super(Namespace.CURRENT.getUriString());
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        final BatchBuilder builder = updateContext.getBatchBuilder();
        new RaDeploymentActivator().activate(new ServiceActivatorContext(){

            public BatchBuilder getBatchBuilder() {
                return builder;
            }
        });
        WorkManagerImpl wm = new WorkManagerImpl();
        WorkManagerService wmService = new WorkManagerService((WorkManager)wm);
        BatchServiceBuilder wmServiceBuilder = builder.addService(ConnectorServices.WORKMANAGER_SERVICE, (Service)wmService);
        wmServiceBuilder.addDependency(ThreadsServices.EXECUTOR.append(new String[]{this.shortRunningThreadPool}), Executor.class, wmService.getExecutorShortInjector());
        wmServiceBuilder.addDependency(ThreadsServices.EXECUTOR.append(new String[]{this.longRunningThreadPool}), Executor.class, wmService.getExecutorLongInjector());
        wmServiceBuilder.addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, wmService.getXaTerminatorInjector());
        wmServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        BaseCloneableBootstrapContext ctx = new BaseCloneableBootstrapContext();
        DefaultBootStrapContextService defaultBootCtxService = new DefaultBootStrapContextService((CloneableBootstrapContext)ctx);
        BatchServiceBuilder defaultBootCtxServiceBuilder = builder.addService(ConnectorServices.DEFAULT_BOOTSTRAP_CONTEXT_SERVICE, (Service)defaultBootCtxService);
        defaultBootCtxServiceBuilder.addDependency(ConnectorServices.WORKMANAGER_SERVICE, WorkManager.class, defaultBootCtxService.getWorkManagerValueInjector());
        defaultBootCtxServiceBuilder.addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, defaultBootCtxService.getXaTerminatorInjector());
        defaultBootCtxServiceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManagerService.class, defaultBootCtxService.getTxManagerInjector());
        defaultBootCtxServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ConnectorSubsystemConfiguration config = new ConnectorSubsystemConfiguration();
        config.setArchiveValidation(this.archiveValidation);
        config.setArchiveValidationFailOnError(this.archiveValidationFailOnError);
        config.setArchiveValidationFailOnWarn(this.archiveValidationFailOnWarn);
        config.setBeanValidation(false);
        ConnectorConfigService connectorConfigService = new ConnectorConfigService(config);
        BatchServiceBuilder configServiceBuilder = builder.addService(ConnectorServices.CONNECTOR_CONFIG_SERVICE, (Service)connectorConfigService);
        configServiceBuilder.addDependency(ConnectorServices.DEFAULT_BOOTSTRAP_CONTEXT_SERVICE, CloneableBootstrapContext.class, connectorConfigService.getDefaultBootstrapContextInjector());
        configServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
    }

    protected void applyUpdate(ConnectorSubsystemElement element) throws UpdateFailedException {
        element.setArchiveValidation(this.archiveValidation);
        element.setArchiveValidationFailOnError(this.archiveValidationFailOnError);
        element.setArchiveValidationFailOnWarn(this.archiveValidationFailOnWarn);
        element.setBeanValidation(false);
        element.setLongRunningThreadPool(this.longRunningThreadPool);
        element.setShortRunningThreadPool(this.shortRunningThreadPool);
    }

    protected ConnectorSubsystemElement createSubsystemElement() {
        ConnectorSubsystemElement element = new ConnectorSubsystemElement();
        element.setArchiveValidation(this.archiveValidation);
        element.setArchiveValidationFailOnError(this.archiveValidationFailOnError);
        element.setArchiveValidationFailOnWarn(this.archiveValidationFailOnWarn);
        element.setBeanValidation(false);
        element.setLongRunningThreadPool(this.longRunningThreadPool);
        element.setShortRunningThreadPool(this.shortRunningThreadPool);
        return element;
    }

    public boolean isArchiveValidation() {
        return this.archiveValidation;
    }

    public void setArchiveValidation(boolean archiveValidation) {
        this.archiveValidation = archiveValidation;
    }

    public boolean isArchiveValidationFailOnError() {
        return this.archiveValidationFailOnError;
    }

    public void setArchiveValidationFailOnError(boolean archiveValidationFailOnError) {
        this.archiveValidationFailOnError = archiveValidationFailOnError;
    }

    public boolean isArchiveValidationFailOnWarn() {
        return this.archiveValidationFailOnWarn;
    }

    public void setArchiveValidationFailOnWarn(boolean archiveValidationFailOnWarn) {
        this.archiveValidationFailOnWarn = archiveValidationFailOnWarn;
    }

    public boolean isBeanValidation() {
        return false;
    }

    public void setBeanValidation(boolean beanValidation) {
        this.beanValidation = beanValidation;
    }

    public String getShortRunningThreadPool() {
        return this.shortRunningThreadPool;
    }

    public void setShortRunningThreadPool(String shortRunningThreadPool) {
        this.shortRunningThreadPool = shortRunningThreadPool;
    }

    public String getLongRunningThreadPool() {
        return this.longRunningThreadPool;
    }

    public void setLongRunningThreadPool(String longRunningThreadPool) {
        this.longRunningThreadPool = longRunningThreadPool;
    }
}

