/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class AbstractControllerService
implements Service<ModelController> {
    private final OperationContext.Type controllerType;
    private final ConfigurationPersister configurationPersister;
    private final DescriptionProvider rootDescriptionProvider;
    private final ControlledProcessState processState;
    private final OperationStepHandler prepareStep;
    private volatile ModelControllerImpl controller;

    protected AbstractControllerService(OperationContext.Type controllerType, ConfigurationPersister configurationPersister, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep) {
        this.controllerType = controllerType;
        this.configurationPersister = configurationPersister;
        this.rootDescriptionProvider = rootDescriptionProvider;
        this.processState = processState;
        this.prepareStep = prepareStep;
    }

    public void start(StartContext context) throws StartException {
        ServiceController serviceController = context.getController();
        ServiceContainer container = serviceController.getServiceContainer();
        ModelControllerImpl controller = new ModelControllerImpl((ServiceRegistry)container, context.getChildTarget(), ManagementResourceRegistration.Factory.create(this.rootDescriptionProvider), new ContainerStateMonitor((ServiceRegistry)container, serviceController), this.configurationPersister, this.controllerType, this.prepareStep, this.processState);
        this.initModel(controller.getRootResource(), controller.getRootRegistration());
        this.controller = controller;
        final ServiceTarget target = context.getChildTarget();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractControllerService.this.boot(new BootContext(){

                        @Override
                        public ServiceTarget getServiceTarget() {
                            return target;
                        }
                    });
                }
                catch (ConfigurationPersistenceException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    AbstractControllerService.this.processState.setRunning();
                }
            }
        }, "Controller Boot Thread").start();
    }

    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        this.boot(this.configurationPersister.load());
        this.finishBoot();
    }

    protected void boot(List<ModelNode> bootOperations) throws ConfigurationPersistenceException {
        this.controller.boot(bootOperations, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT);
    }

    protected void finishBoot() throws ConfigurationPersistenceException {
        this.controller.finshBoot();
        this.configurationPersister.successfulBoot();
    }

    public void stop(StopContext context) {
        this.controller = null;
    }

    public ModelController getValue() throws IllegalStateException, IllegalArgumentException {
        ModelControllerImpl controller = this.controller;
        if (controller == null) {
            throw new IllegalStateException();
        }
        return controller;
    }

    protected abstract void initModel(Resource var1, ManagementResourceRegistration var2);
}

