/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SystemPropertyAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final SystemPropertyAddHandler INSTANCE_WITH_BOOTTIME = new SystemPropertyAddHandler(null, true);
    public static final SystemPropertyAddHandler INSTANCE_WITHOUT_BOOTTIME = new SystemPropertyAddHandler(null, false);
    private final ParametersValidator validator = new ParametersValidator();
    private final ProcessEnvironment processEnvironment;
    private final boolean useBoottime;

    public static ModelNode getOperation(ModelNode address, String value) {
        return SystemPropertyAddHandler.getOperation(address, value, null);
    }

    public static ModelNode getOperation(ModelNode address, String value, Boolean boottime) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        if (value == null) {
            op.get("value").set(new ModelNode());
        } else {
            op.get("value").set(value);
        }
        if (boottime != null) {
            op.get("boot-time").set(boottime.booleanValue());
        }
        return op;
    }

    public SystemPropertyAddHandler(ProcessEnvironment processEnvironment, boolean useBoottime) {
        this.processEnvironment = processEnvironment;
        this.useBoottime = useBoottime;
        this.validator.registerValidator("value", new StringLengthValidator(0, true, true));
        if (useBoottime) {
            this.validator.registerValidator("boot-time", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        final String name = PathAddress.pathAddress(operation.get("address")).getLastElement().getValue();
        String value = operation.hasDefined("value") ? operation.get("value").asString() : null;
        boolean applyToRuntime = this.processEnvironment != null && this.processEnvironment.isRuntimeSystemPropertyUpdateAllowed(name, value, context.isBooting());
        final boolean reload = !applyToRuntime && context.getProcessType().isServer();
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (value == null) {
            model.get("value").set(new ModelNode());
        } else {
            model.get("value").set(value);
        }
        if (this.useBoottime) {
            boolean boottime = !operation.hasDefined("boot-time") || operation.get("boot-time").asBoolean();
            model.get("boot-time").set(boottime);
        }
        if (applyToRuntime) {
            String setValue = value != null ? context.resolveExpressions(operation.require("value")).asString() : null;
            SecurityActions.setSystemProperty(name, setValue);
            if (this.processEnvironment != null) {
                this.processEnvironment.systemPropertyUpdated(name, setValue);
            }
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
                if (SystemPropertyAddHandler.this.processEnvironment != null) {
                    SecurityActions.clearSystemProperty(name);
                    if (SystemPropertyAddHandler.this.processEnvironment != null) {
                        SystemPropertyAddHandler.this.processEnvironment.systemPropertyUpdated(name, null);
                    }
                }
            }
        });
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSystemPropertyOperation(locale, this.useBoottime);
    }
}

