/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.security.Permission;
import javax.security.auth.Subject;

public class SecurityContext {
    private static final RuntimePermission GET_SUBJECT_PERMISSION = new RuntimePermission("org.jboss.as.controller.security.GET_SUBJECT");
    private static final RuntimePermission SET_SUBJECT_PERMISSION = new RuntimePermission("org.jboss.as.controller.security.SET_SUBJECT");
    private static final RuntimePermission CLEAR_SUBJECT_PERMISSION = new RuntimePermission("org.jboss.as.controller.security.CLEAR_SUBJECT");
    private static final ThreadLocal<Subject> subject = new ThreadLocal();

    public static Subject getSubject() {
        SecurityContext.checkPermission(GET_SUBJECT_PERMISSION);
        return subject.get();
    }

    public static void setSubject(Subject subject) {
        SecurityContext.checkPermission(SET_SUBJECT_PERMISSION);
        SecurityContext.subject.set(subject);
    }

    public static void clearSubject() {
        SecurityContext.checkPermission(CLEAR_SUBJECT_PERMISSION);
        subject.set(null);
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

