/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class EjbJndiBindingsDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbJndiBindingsDeploymentUnitProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        for (AbstractComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            this.setupJNDIBindings((SessionBeanComponentDescription)componentDescription, deploymentUnit);
        }
    }

    private void setupJNDIBindings(SessionBeanComponentDescription sessionBean, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        Set views = sessionBean.getViewClassNames();
        if (views == null || views.isEmpty()) {
            logger.info((Object)("No jndi bindings will be created for EJB: " + sessionBean.getEJBName() + " since no views are exposed"));
            return;
        }
        String applicationName = this.getEarName(deploymentUnit);
        String globalJNDIBaseName = "java:global/" + (applicationName != null ? applicationName + "/" : "") + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String appJNDIBaseName = "java:app/" + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String moduleJNDIBaseName = "java:module/" + sessionBean.getEJBName();
        ServiceName baseServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{sessionBean.getComponentName()});
        for (String viewClassName : views) {
            String globalJNDIName = globalJNDIBaseName + "!" + viewClassName;
            BindingDescription globalBinding = new BindingDescription(globalJNDIName);
            globalBinding.setBindingType(viewClassName);
            globalBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            sessionBean.addBinding(globalBinding);
            logger.debug((Object)("Added java:global jndi binding at " + globalJNDIName + " for view: " + viewClassName + " of session bean: " + sessionBean.getEJBName()));
            String appJNDIName = appJNDIBaseName + "!" + viewClassName;
            BindingDescription appBinding = new BindingDescription(appJNDIName);
            appBinding.setBindingType(viewClassName);
            appBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            sessionBean.addBinding(appBinding);
            logger.debug((Object)("Added java:app jndi binding at " + appJNDIName + " for view: " + viewClassName + " of session bean: " + sessionBean.getEJBName()));
            String moduleJNDIName = moduleJNDIBaseName + "!" + viewClassName;
            BindingDescription moduleBinding = new BindingDescription(moduleJNDIName);
            moduleBinding.setBindingType(viewClassName);
            moduleBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            sessionBean.addBinding(moduleBinding);
            logger.debug((Object)("Added java:module jndi binding at " + moduleJNDIName + " for view: " + viewClassName + " of session bean: " + sessionBean.getEJBName()));
        }
        if (views.size() == 1) {
            String viewClassName;
            BindingDescription globalBinding = new BindingDescription(globalJNDIBaseName);
            viewClassName = (String)views.iterator().next();
            globalBinding.setBindingType(viewClassName);
            globalBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            sessionBean.addBinding(globalBinding);
            logger.debug((Object)("Added java:global jndi binding at " + globalJNDIBaseName + " for view: " + viewClassName + " of session bean: " + sessionBean.getEJBName()));
            BindingDescription appBinding = new BindingDescription(appJNDIBaseName);
            appBinding.setBindingType(viewClassName);
            appBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            sessionBean.addBinding(appBinding);
            logger.debug((Object)("Added java:app jndi binding at " + appJNDIBaseName + " for view: " + viewClassName + " of session bean: " + sessionBean.getEJBName()));
            BindingDescription moduleBinding = new BindingDescription(moduleJNDIBaseName);
            moduleBinding.setBindingType(viewClassName);
            moduleBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            sessionBean.addBinding(moduleBinding);
            logger.debug((Object)("Added java:module jndi binding at " + moduleJNDIBaseName + " for view: " + viewClassName + " of session bean: " + sessionBean.getEJBName()));
        }
    }

    private String getEarName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        if (parentDU == null) {
            String duName = deploymentUnit.getName();
            if (duName.endsWith(".ear")) {
                return duName.substring(0, duName.length() - ".ear".length());
            }
            return null;
        }
        while (parentDU.getParent() != null) {
            parentDU = parentDU.getParent();
        }
        String duName = parentDU.getName();
        if (duName.endsWith(".ear")) {
            return duName.substring(0, duName.length() - ".ear".length());
        }
        return null;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

