/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EjbExceptionTransformingInterceptorFactory
implements InterceptorFactory {
    public static final EjbExceptionTransformingInterceptorFactory INSTANCE = new EjbExceptionTransformingInterceptorFactory();

    public Interceptor create(InterceptorFactoryContext context) {
        return new Interceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                try {
                    return context.proceed();
                }
                catch (EJBTransactionRequiredException e) {
                    throw new TransactionRequiredException(e.getMessage());
                }
                catch (EJBTransactionRolledbackException e) {
                    throw new TransactionRolledbackException(e.getMessage());
                }
                catch (NoSuchEJBException e) {
                    throw new NoSuchObjectException(e.getMessage());
                }
                catch (NoSuchEntityException e) {
                    throw new NoSuchObjectException(e.getMessage());
                }
                catch (EJBException e) {
                    throw new RemoteException("Invocation failed", e);
                }
                catch (Error e) {
                    throw new RemoteException("Unexpected error", e);
                }
            }
        };
    }
}

