/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.context;

import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EjbComponentInstance;
import org.jboss.as.ejb3.context.EJBContextImpl;
import org.jboss.as.ejb3.util.ThreadLocalStack;
import org.jboss.invocation.InterceptorContext;

public class CurrentInvocationContext {
    private static final ThreadLocalStack<InterceptorContext> stack = new ThreadLocalStack();

    public static InterceptorContext get() {
        InterceptorContext current = stack.get();
        return current;
    }

    public static <T extends InterceptorContext> T get(Class<T> expectedType) {
        return (T)((InterceptorContext)expectedType.cast(CurrentInvocationContext.get()));
    }

    public static EJBContextImpl getEjbContext() {
        InterceptorContext context = CurrentInvocationContext.get();
        ComponentInstance component = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
        if (!(component instanceof EjbComponentInstance)) {
            throw EjbMessages.MESSAGES.currentComponentNotAEjb(component);
        }
        return ((EjbComponentInstance)component).getEjbContext();
    }

    public static InterceptorContext pop() {
        return stack.pop();
    }

    public static void push(InterceptorContext invocation) {
        assert (invocation != null) : "invocation is null";
        stack.push(invocation);
    }
}

