/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;

class XidTransactionCommitTask
extends XidTransactionManagementTask {
    private static final Logger logger = Logger.getLogger(XidTransactionCommitTask.class);
    private final boolean onePhaseCommit;

    XidTransactionCommitTask(TransactionRequestHandler txRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, XidTransactionID xidTransactionID, Channel channel, short invocationId, boolean onePhaseCommit) {
        super(txRequestHandler, transactionsRepository, xidTransactionID, channel, invocationId);
        this.onePhaseCommit = onePhaseCommit;
    }

    @Override
    protected void manageTransaction() throws Throwable {
        block16: {
            Transaction transaction = this.transactionsRepository.removeTransaction((TransactionID)this.xidTransactionID);
            this.resumeTransaction(transaction);
            Xid xid = this.xidTransactionID.getXid();
            try {
                SubordinateTransaction subordinateTransaction = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
                if (subordinateTransaction == null) {
                    throw new XAException(-5);
                }
                if (subordinateTransaction.activated()) {
                    this.hackJTS(subordinateTransaction);
                    if (this.onePhaseCommit) {
                        subordinateTransaction.doOnePhaseCommit();
                    } else {
                        subordinateTransaction.doCommit();
                    }
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                    break block16;
                }
                throw new XAException(4);
            }
            catch (RollbackException e) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                XAException xaException = new XAException(100);
                xaException.initCause(e);
                throw xaException;
            }
            catch (XAException ex) {
                if (ex.errorCode != 4) {
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                }
                throw ex;
            }
            catch (HeuristicRollbackException ex) {
                XAException xaException = new XAException(6);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (HeuristicMixedException ex) {
                XAException xaException = new XAException(5);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (HeuristicCommitException ex) {
                XAException xaException = new XAException(7);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (IllegalStateException ex) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                XAException xaException = new XAException(-4);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (SystemException ex) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                XAException xaException = new XAException(-3);
                xaException.initCause(ex);
                throw xaException;
            }
            finally {
                this.transactionsRepository.getTransactionManager().suspend();
            }
        }
    }

    private void hackJTS(SubordinateTransaction subordinateTransaction) {
        if (subordinateTransaction instanceof TransactionImple) {
            TransactionImple txImple = (TransactionImple)subordinateTransaction;
            ControlWrapper controlWrapper = txImple.getControlWrapper();
            if (controlWrapper == null) {
                return;
            }
            ControlImple controlImple = controlWrapper.getImple();
            if (controlImple == null) {
                return;
            }
            ArjunaTransactionImple arjunaTransactionImple = controlImple.getImplHandle();
            if (arjunaTransactionImple == null) {
                return;
            }
            logger.debug((Object)("Applying a JTS hack to setControlHandle " + controlImple + " on subordinate tx " + subordinateTransaction));
            arjunaTransactionImple.setControlHandle(controlImple);
        }
    }
}

