/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Set;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptor;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class SecurityContextInterceptorFactory
extends ComponentInterceptorFactory {
    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw EjbMessages.MESSAGES.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        SimpleSecurityManager securityManager = ejbComponent.getSecurityManager();
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomain = securityMetaData.getSecurityDomain();
        if (securityDomain == null) {
            throw EjbMessages.MESSAGES.invalidSecurityForDomainSet(ejbComponent.getComponentName());
        }
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Using security domain: " + securityDomain + " for EJB " + ejbComponent.getComponentName());
        }
        String runAs = securityMetaData.getRunAs();
        String runAsPrincipal = securityMetaData.getRunAsPrincipal();
        SecurityRolesMetaData securityRoles = securityMetaData.getSecurityRoles();
        Set extraRoles = null;
        if (securityRoles != null) {
            extraRoles = securityRoles.getSecurityRoleNamesByPrincipal(runAsPrincipal);
        }
        return new SecurityContextInterceptor(securityManager, securityDomain, runAs, runAsPrincipal, extraRoles);
    }
}

