/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EJB3Subsystem11Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final EJB3Subsystem11Parser INSTANCE = new EJB3Subsystem11Parser();

    private EJB3Subsystem11Parser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:ejb3:1.1", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("lite")) {
            writer.writeAttribute("lite", model.get("lite").asString());
        }
        if (model.hasDefined("default-mdb-instance-pool") || model.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.MDB.getLocalName());
            this.writeMDB(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.SESSION_BEAN.getLocalName());
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, model);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (model.hasDefined("strict-max-bean-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.POOLS.getLocalName());
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, model);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("timer-service")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.TIMER_SERVICE.getLocalName());
            ModelNode timerServiceModel = model.get(new String[]{"service", "timer-service"});
            this.writeTimerService(writer, timerServiceModel);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode ejb3SubsystemAddOperation = new ModelNode();
        ejb3SubsystemAddOperation.get("operation").set("add");
        ejb3SubsystemAddOperation.get("address").add("subsystem", "ejb3");
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<EJB3SubsystemXMLElement> encountered = EnumSet.noneOf(EJB3SubsystemXMLElement.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case EJB3_1_1: {
                    EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case MDB: {
                            this.parseMDB(reader, operations, ejb3SubsystemAddOperation);
                            continue block9;
                        }
                        case POOLS: {
                            this.parsePools(reader, operations);
                            continue block9;
                        }
                        case SESSION_BEAN: {
                            this.parseSessionBean(reader, operations, ejb3SubsystemAddOperation);
                            continue block9;
                        }
                        case TIMER_SERVICE: {
                            this.parseTimerService(reader, operations);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void writeMDB(XMLExtendedStreamWriter writer, ModelNode mdbModelNode) throws XMLStreamException {
        if (mdbModelNode.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.RESOURCE_ADAPTER_REF.getLocalName());
            String resourceAdapterName = mdbModelNode.get("default-resource-adapter-name").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName(), resourceAdapterName);
            writer.writeEndElement();
        }
        if (mdbModelNode.hasDefined("default-mdb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = mdbModelNode.get("default-mdb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writeSessionBean(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            ModelNode statelessBeanModeNode = model.get(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, statelessBeanModeNode);
            writer.writeEndElement();
        }
    }

    private void writeDefaultSLSBPool(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = model.get("default-slsb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writePools(XMLExtendedStreamWriter writer, ModelNode poolsModelNode) throws XMLStreamException {
        if (poolsModelNode.hasDefined(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName())) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            ModelNode beanInstancePoolsModelNode = poolsModelNode.get(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, beanInstancePoolsModelNode);
            writer.writeEndElement();
        }
    }

    private void writeBeanInstancePools(XMLExtendedStreamWriter writer, ModelNode beanInstancePoolModelNode) throws XMLStreamException {
        if (beanInstancePoolModelNode.hasDefined("strict-max-bean-instance-pool")) {
            List strictMaxPools = beanInstancePoolModelNode.get("strict-max-bean-instance-pool").asPropertyList();
            for (Property property : strictMaxPools) {
                writer.writeStartElement(EJB3SubsystemXMLElement.STRICT_MAX_POOL.getLocalName());
                ModelNode strictMaxPoolModelNode = property.getValue();
                this.writeStrictMaxPoolConfig(writer, strictMaxPoolModelNode);
                writer.writeEndElement();
            }
        }
    }

    private void writeStrictMaxPoolConfig(XMLExtendedStreamWriter writer, ModelNode strictMaxPoolModelNode) throws XMLStreamException {
        String poolName = strictMaxPoolModelNode.get("name").asString();
        writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), poolName);
        StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
    }

    private void writeTimerService(XMLExtendedStreamWriter writer, ModelNode timerServiceModel) throws XMLStreamException {
        writer.writeAttribute("thread-pool-name", "default");
        if (TimerServiceResourceDefinition.PATH.isMarshallable(timerServiceModel) || TimerServiceResourceDefinition.RELATIVE_TO.isMarshallable(timerServiceModel)) {
            writer.writeEmptyElement(EJB3SubsystemXMLElement.DATA_STORE.getLocalName());
            TimerServiceResourceDefinition.PATH.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
            TimerServiceResourceDefinition.RELATIVE_TO.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
        }
    }

    private ModelNode parseMDB(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ModelNode mdbModelNode = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, reader.getLocation());
                    continue block4;
                }
                case RESOURCE_ADAPTER_REF: {
                    String resourceAdapterName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.parseAndSetParameter(resourceAdapterName, ejb3SubsystemAddOperation, reader.getLocation());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return mdbModelNode;
    }

    private void parseSessionBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATELESS: {
                    this.parseStatelessBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStatelessBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, reader.getLocation());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOLS: {
                    this.parseBeanInstancePools(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBeanInstancePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STRICT_MAX_POOL: {
                    this.parseStrictMaxPool(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStrictMaxPool(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String poolName = null;
        Integer maxPoolSize = null;
        Long timeout = null;
        String unit = null;
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    poolName = value;
                    continue block6;
                }
                case MAX_POOL_SIZE: {
                    maxPoolSize = StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.parse(value, reader.getLocation()).asInt();
                    continue block6;
                }
                case INSTANCE_AQUISITION_TIMEOUT: {
                    timeout = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.parse(value, reader.getLocation()).asLong();
                    continue block6;
                }
                case INSTANCE_AQUISITION_TIMEOUT_UNIT: {
                    unit = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.parse(value, reader.getLocation()).asString();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (poolName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddStrictMaxBeanInstancePoolOperation(poolName, maxPoolSize, timeout, unit));
    }

    private void parseTimerService(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "timer-service");
        ModelNode timerServiceAdd = new ModelNode();
        timerServiceAdd.get("operation").set("add");
        timerServiceAdd.get("address").set(address);
        Object coreThreads = null;
        Object maxThreads = null;
        String dataStorePath = null;
        String dataStorePathRelativeTo = null;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case THREAD_POOL: {
                    EJB3SubsystemXMLAttribute attribute;
                    String value;
                    Location location;
                    int i;
                    int count = reader.getAttributeCount();
                    block13: for (i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        location = reader.getLocation();
                        value = reader.getAttributeValue(i);
                        attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case CORE_THREADS: {
                                continue block13;
                            }
                            case MAX_THREADS: {
                                continue block13;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block12;
                }
                case DATA_STORE: {
                    EJB3SubsystemXMLAttribute attribute;
                    String value;
                    Location location;
                    int i;
                    int count = reader.getAttributeCount();
                    block14: for (i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        location = reader.getLocation();
                        value = reader.getAttributeValue(i);
                        attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case PATH: {
                                if (dataStorePath != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePath = TimerServiceResourceDefinition.PATH.parse(value, location).asString();
                                continue block14;
                            }
                            case RELATIVE_TO: {
                                if (dataStorePathRelativeTo != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePathRelativeTo = TimerServiceResourceDefinition.RELATIVE_TO.parse(value, location).asString();
                                continue block14;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (dataStorePath == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.PATH));
                    }
                    timerServiceAdd.get("path").set(dataStorePath);
                    if (dataStorePathRelativeTo != null) {
                        timerServiceAdd.get("relative-to").set(dataStorePathRelativeTo);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(timerServiceAdd);
    }

    private void parseAttributes(XMLExtendedStreamReader reader, ModelNode node, EnumSet<EJB3SubsystemXMLAttribute> expectedAttributes, EnumSet<EJB3SubsystemXMLAttribute> requiredAttributes) throws XMLStreamException {
        EnumSet<EJB3SubsystemXMLAttribute> parsedAttributes = EnumSet.noneOf(EJB3SubsystemXMLAttribute.class);
        if (requiredAttributes == null) {
            requiredAttributes = EnumSet.noneOf(EJB3SubsystemXMLAttribute.class);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            if (!expectedAttributes.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (!parsedAttributes.add(attribute)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
            }
            requiredAttributes.remove((Object)attribute);
            node.get(attribute.getLocalName()).set(attrValue);
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
    }

    private ModelNode createSetDefaultWriteAttributeOperation(SimpleAttributeDefinition attributeDefinition, String rawValue, Location location) throws XMLStreamException {
        ModelNode parsed = attributeDefinition.parse(rawValue, location);
        ModelNode setDefaultSLSBPoolOperation = new ModelNode();
        setDefaultSLSBPoolOperation.get("operation").set("write-attribute");
        setDefaultSLSBPoolOperation.get("address").set(this.getEJB3SubsystemAddress().toModelNode());
        setDefaultSLSBPoolOperation.get("name").set(attributeDefinition.getName());
        setDefaultSLSBPoolOperation.get("value").set(parsed);
        return setDefaultSLSBPoolOperation;
    }

    private ModelNode createAddStrictMaxBeanInstancePoolOperation(String name, Integer maxPoolSize, Long timeout, String timeoutUnit) {
        ModelNode addStrictMaxPoolOperation = new ModelNode();
        addStrictMaxPoolOperation.get("operation").set("add");
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"strict-max-bean-instance-pool", (String)name)});
        addStrictMaxPoolOperation.get("address").set(address.toModelNode());
        if (maxPoolSize != null) {
            addStrictMaxPoolOperation.get("max-pool-size").set(maxPoolSize.intValue());
        }
        if (timeout != null) {
            addStrictMaxPoolOperation.get("timeout").set(timeout.longValue());
        }
        if (timeoutUnit != null) {
            addStrictMaxPoolOperation.get("timeout-unit").set(timeoutUnit);
        }
        return addStrictMaxPoolOperation;
    }

    private PathAddress getEJB3SubsystemAddress() {
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"ejb3")});
        return addr;
    }
}

