/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;

public class PersistenceProviderAdaptorLoader {
    private static final Map<String, PersistenceProviderAdaptor> adaptorMap = Collections.synchronizedMap(new HashMap());
    private static final PersistenceProviderAdaptor noopAdaptor = new PersistenceProviderAdaptor(){

        public void injectJtaManager(JtaManager jtaManager) {
        }

        public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        }

        public Iterable<ServiceName> getProviderDependencies(PersistenceUnitMetadata pu) {
            return null;
        }

        public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public ManagementAdaptor getManagementAdaptor() {
            return null;
        }
    };

    public static PersistenceProviderAdaptor loadPersistenceAdapterModule(String adapterModule) throws ModuleLoadException {
        Module module;
        ServiceLoader serviceLoader;
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (adapterModule == null) {
            return noopAdaptor;
        }
        PersistenceProviderAdaptor persistenceProviderAdaptor = adaptorMap.get(adapterModule);
        if (persistenceProviderAdaptor == null && (serviceLoader = (module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)adapterModule))).loadService(PersistenceProviderAdaptor.class)) != null) {
            for (PersistenceProviderAdaptor adaptor : serviceLoader) {
                if (persistenceProviderAdaptor != null) {
                    throw JpaMessages.MESSAGES.multipleAdapters(adapterModule);
                }
                persistenceProviderAdaptor = adaptor;
                JpaLogger.JPA_LOGGER.debugf("loaded persistence provider adapter %s", (Object)adapterModule);
            }
            if (persistenceProviderAdaptor != null) {
                persistenceProviderAdaptor.injectJtaManager(JtaManagerImpl.getInstance());
                adaptorMap.put(adapterModule, persistenceProviderAdaptor);
            }
        }
        return persistenceProviderAdaptor;
    }
}

