/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionServer;
import org.jboss.as.mail.extension.MailSessionService;
import org.jboss.as.mail.extension.Util;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class MailSessionAdd
extends AbstractAddStepHandler {
    static final MailSessionAdd INSTANCE = new MailSessionAdd();
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"mail-session"});

    private MailSessionAdd() {
    }

    protected void populateModel(ModelNode existingModel, ModelNode newModel) throws OperationFailedException {
        MailSessionAdd.copyModel(existingModel, newModel, "jndi-name", "debug");
        if (existingModel.hasDefined("smtp-server")) {
            newModel.get("smtp-server").set(existingModel.get("smtp-server"));
        }
        if (existingModel.hasDefined("pop3-server")) {
            newModel.get("pop3-server").set(existingModel.get("pop3-server"));
        }
        if (existingModel.hasDefined("imap-server")) {
            newModel.get("imap-server").set(existingModel.get("imap-server"));
        }
    }

    static void copyModel(ModelNode src, ModelNode target, String ... params) {
        for (String p : params) {
            target.get(p).set(src.get(p).asString());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        final String jndiName = Util.getJndiName(operation);
        ServiceTarget serviceTarget = context.getServiceTarget();
        MailSessionConfig config = Util.from(context, operation);
        final MailSessionService service = new MailSessionService(config);
        ServiceName serviceName = SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder mailSessionBuilder = serviceTarget.addService(serviceName, (Service)service);
        this.addOutboundSocketDependency(service, mailSessionBuilder, config.getImapServer());
        this.addOutboundSocketDependency(service, mailSessionBuilder, config.getPop3Server());
        this.addOutboundSocketDependency(service, mailSessionBuilder, config.getSmtpServer());
        ManagedReferenceFactory valueManagedReferenceFactory = new ManagedReferenceFactory(){

            public ManagedReference getReference() {
                return new ValueManagedReference((Value)new ImmediateValue((Object)service.getValue()));
            }
        };
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addInjection(binderService.getManagedObjectInjector(), (Object)valueManagedReferenceFactory).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        MailLogger.ROOT_LOGGER.boundMailSession(jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        MailLogger.ROOT_LOGGER.unboundMailSession(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        MailLogger.ROOT_LOGGER.removedMailSession(jndiName);
                    }
                }
            }
        });
        mailSessionBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
        controllers.add(mailSessionBuilder.install());
        controllers.add(binderBuilder.install());
    }

    private void addOutboundSocketDependency(MailSessionService service, ServiceBuilder<?> mailSessionBuilder, MailSessionServer server) {
        if (server != null) {
            String ref = server.getOutgoingSocketBinding();
            mailSessionBuilder.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{ref}), OutboundSocketBinding.class, service.getSocketBindingInjector(ref));
        }
    }
}

