/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.modcluster.Attribute;
import org.jboss.as.modcluster.Element;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ModClusterSubsystemElementParser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext>,
XMLStreamConstants {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "modcluster");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MODCLUSTER: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MOD_CLUSTER_CONFIG: {
                            ModelNode config = ModClusterSubsystemElementParser.parseModClusterConfig(reader);
                            subsystem.get("mod-cluster-config").set(config);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        ModClusterSubsystemElementParser.writeModClusterConfig(writer, node);
        writer.writeEndElement();
    }

    static void writeModClusterConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.MOD_CLUSTER_CONFIG.getLocalName());
        ModClusterSubsystemElementParser.writePropConf(writer, config);
        if (config.hasDefined("simple-load-provider")) {
            ModClusterSubsystemElementParser.writeSimpleLoadProvider(writer, config.get("simple-load-provider"));
        }
        if (config.hasDefined("dynamic-load-provider")) {
            ModClusterSubsystemElementParser.writeDynamicLoadProvider(writer, config.get("dynamic-load-provider"));
        }
        if (config.hasDefined("ssl")) {
            ModClusterSubsystemElementParser.writeSSL(writer, config.get("ssl"));
        }
        writer.writeEndElement();
    }

    static ModelNode parseModClusterConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode config = new ModelNode();
        ModClusterSubsystemElementParser.parsePropConf(reader, config);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SIMPLE_LOAD_PROVIDER: {
                    ModelNode load = ModClusterSubsystemElementParser.parseSimpleLoadProvider(reader);
                    config.get("simple-load-provider").set(load);
                    continue block5;
                }
                case DYNAMIC_LOAD_PROVIDER: {
                    ModelNode dynload = ModClusterSubsystemElementParser.parseDynamicLoadProvider(reader);
                    config.get("dynamic-load-provider").set(dynload);
                    continue block5;
                }
                case SSL: {
                    ModelNode ssl = ModClusterSubsystemElementParser.parseSSL(reader);
                    config.get("ssl").set(ssl);
                    continue block5;
                }
            }
            ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return config;
    }

    static void writePropConf(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        ModClusterSubsystemElementParser.writeAttribute(writer, "advertise-socket", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "proxy-list", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "proxy-url", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "advertise", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "advertise-security-key", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "excluded-contexts", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "auto-enable-contexts", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "stop-context-timeout", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "socket-timeout", config);
    }

    static void parsePropConf(XMLExtendedStreamReader reader, ModelNode conf) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ADVERTISE_SOCKET: {
                    conf.get("advertise-socket").set(value);
                    continue block11;
                }
                case PROXY_LIST: {
                    conf.get("proxy-list").set(value);
                    continue block11;
                }
                case PROXY_URL: {
                    conf.get("proxy-url").set(value);
                    continue block11;
                }
                case ADVERTISE: {
                    conf.get("advertise").set(value);
                    continue block11;
                }
                case ADVERTISE_SECURITY_KEY: {
                    conf.get("advertise-security-key").set(value);
                    continue block11;
                }
                case EXCLUDED_CONTEXTS: {
                    conf.get("excluded-contexts").set(value);
                    continue block11;
                }
                case AUTO_ENABLE_CONTEXTS: {
                    conf.get("auto-enable-contexts").set(value);
                    continue block11;
                }
                case STOP_CONTEXT_TIMEOUT: {
                    conf.get("stop-context-timeout").set(value);
                    continue block11;
                }
                case SOCKET_TIMEOUT: {
                    conf.get("socket-timeout").set(value);
                    continue block11;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    static void writeSSL(XMLExtendedStreamWriter writer, ModelNode sslConfig) throws XMLStreamException {
        writer.writeStartElement(Element.SSL.getLocalName());
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.KEY_ALIAS.getLocalName(), sslConfig);
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.PASSWORD.getLocalName(), sslConfig);
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.CERTIFICATE_KEY_FILE.getLocalName(), sslConfig);
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.CIPHER_SUITE.getLocalName(), sslConfig);
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.PROTOCOL.getLocalName(), sslConfig);
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.CA_CERTIFICATE_FILE.getLocalName(), sslConfig);
        ModClusterSubsystemElementParser.writeAttribute(writer, Attribute.CA_REVOCATION_URL.getLocalName(), sslConfig);
        writer.writeEndElement();
    }

    static ModelNode parseSSL(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.setEmptyObject();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_ALIAS: {
                    ssl.get("key-alias").set(value);
                    continue block9;
                }
                case PASSWORD: {
                    ssl.get("password").set(value);
                    continue block9;
                }
                case CERTIFICATE_KEY_FILE: {
                    ssl.get("certificate-key-file").set(value);
                    continue block9;
                }
                case CIPHER_SUITE: {
                    ssl.get("cipher-suite").set(value);
                    continue block9;
                }
                case PROTOCOL: {
                    ssl.get("protocol").set(value);
                    continue block9;
                }
                case CA_CERTIFICATE_FILE: {
                    ssl.get("ca-certificate-file").set(value);
                    continue block9;
                }
                case CA_REVOCATION_URL: {
                    ssl.get("ca-revocation-url").set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return ssl;
    }

    static void writeSimpleLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.SIMPLE_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemElementParser.writeAttribute(writer, "factor", config);
        writer.writeEndElement();
    }

    static ModelNode parseSimpleLoadProvider(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTOR: {
                    load.get("factor").set(value);
                    continue block3;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return load;
    }

    static void writeDynamicLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.DYNAMIC_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemElementParser.writeAttribute(writer, "history", config);
        ModClusterSubsystemElementParser.writeAttribute(writer, "decay", config);
        if (config.hasDefined("load-metric")) {
            ModClusterSubsystemElementParser.writeLoadMetric(writer, config.get("load-metric"));
        }
        if (config.hasDefined("custom-load-metric")) {
            ModClusterSubsystemElementParser.writeCustomLoadMetric(writer, config.get("custom-load-metric"));
        }
        writer.writeEndElement();
    }

    static ModelNode parseDynamicLoadProvider(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HISTORY: {
                    load.get("history").set(value);
                    continue block8;
                }
                case DECAY: {
                    load.get("decay").set(value);
                    continue block8;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOAD_METRIC: {
                    ModelNode loadmetric = ModClusterSubsystemElementParser.parseLoadMetric(reader);
                    load.get("load-metric").add(loadmetric);
                    continue block9;
                }
                case CUSTOM_LOAD_METRIC: {
                    ModelNode customloadmetric = ModClusterSubsystemElementParser.parseCustomLoadMetric(reader);
                    load.get("custom-load-metric").add(customloadmetric);
                    continue block9;
                }
            }
            ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static void writeLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        List array = config.asList();
        for (ModelNode node : array) {
            writer.writeStartElement(Element.LOAD_METRIC.getLocalName());
            ModClusterSubsystemElementParser.writeAttribute(writer, "type", node);
            ModClusterSubsystemElementParser.writeAttribute(writer, "weight", node);
            ModClusterSubsystemElementParser.writeAttribute(writer, "capacity", node);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemElementParser.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static ModelNode parseLoadMetric(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    load.get("type").set(value);
                    continue block8;
                }
                case CAPACITY: {
                    load.get("capacity").set(value);
                    continue block8;
                }
                case WEIGHT: {
                    load.get("weight").set(value);
                    continue block8;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ModClusterSubsystemElementParser.parseProperty(reader);
                    load.get("property").add(property.getName(), property.getValue());
                    continue block9;
                }
            }
            ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static void writeCustomLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        List array = config.asList();
        for (ModelNode node : array) {
            writer.writeStartElement(Element.CUSTOM_LOAD_METRIC.getLocalName());
            ModClusterSubsystemElementParser.writeAttribute(writer, "capacity", node);
            ModClusterSubsystemElementParser.writeAttribute(writer, "weight", node);
            ModClusterSubsystemElementParser.writeAttribute(writer, "class", node);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemElementParser.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static ModelNode parseCustomLoadMetric(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CAPACITY: {
                    load.get("capacity").set(value);
                    continue block8;
                }
                case WEIGHT: {
                    load.get("weight").set(value);
                    continue block8;
                }
                case CLASS: {
                    load.get("class").set(value);
                    continue block8;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ModClusterSubsystemElementParser.parseProperty(reader);
                    load.get("property").add(property.getName(), property.getValue());
                    continue block9;
                }
            }
            ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }

    static void writeProperty(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTY.getLocalName());
        writer.writeAttribute("name", property.getName());
        writer.writeAttribute("value", property.getValue().asString());
        writer.writeEndElement();
    }

    static Property parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        String value = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("value")) {
                value = reader.getAttributeValue(i);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new Property(name, new ModelNode().set(value == null ? "" : value));
    }
}

