/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class ModClusterSubsystemAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final ModClusterSubsystemAdd INSTANCE = new ModClusterSubsystemAdd();
    static final PathElement SSLPath = PathElement.pathElement((String)"ssl", (String)"configuration");
    static final PathElement confPath = PathElement.pathElement((String)"mod-cluster-config", (String)"configuration");

    ModClusterSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, Resource resource) {
        if (operation.hasDefined("mod-cluster-config")) {
            ModelNode configuration = operation.get("mod-cluster-config").hasDefined("configuration") ? operation.get("mod-cluster-config").get("configuration") : operation.get("mod-cluster-config");
            resource.registerChild(confPath, Resource.Factory.create());
            Resource conf = resource.getChild(confPath);
            for (String attribute : configuration.keys()) {
                if (attribute.equals("ssl")) {
                    conf.registerChild(SSLPath, Resource.Factory.create());
                    Resource ssl = conf.getChild(SSLPath);
                    ModelNode sslnode = configuration.get(attribute).hasDefined("configuration") ? configuration.get(attribute).get("configuration") : configuration.get(attribute);
                    ModClusterSubsystemAdd.populateConf(ssl.getModel(), sslnode);
                    continue;
                }
                conf.getModel().get(attribute).set(configuration.get(attribute));
            }
        }
    }

    static void populateConf(ModelNode subModel, ModelNode operation) {
        for (String attribute : operation.keys()) {
            if (!operation.hasDefined(attribute)) continue;
            subModel.get(attribute).set(operation.get(attribute));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String bindingRef = null;
        ModelNode node = operation.get("mod-cluster-config");
        if (operation.hasDefined("mod-cluster-config")) {
            if (operation.get("mod-cluster-config").hasDefined("configuration")) {
                node = operation.get("mod-cluster-config").get("configuration");
            }
            if (node.hasDefined("advertise-socket")) {
                bindingRef = node.get("advertise-socket").asString();
            }
        }
        try {
            ModClusterService service = new ModClusterService(this.unmaskPassword(context, model), node.clone());
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ModClusterService.NAME, (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getBindingManager()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE);
            if (bindingRef != null) {
                serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding());
            }
            newControllers.add(serviceBuilder.install());
        }
        catch (Throwable t) {
            ModClusterLogger.ROOT_LOGGER.debugf("Error: %s", t);
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getSubsystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }

    private String unmaskPassword(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined("ssl")) {
            return null;
        }
        if (!model.get("ssl").hasDefined("password")) {
            return null;
        }
        return context.resolveExpressions(model.get(new String[]{"ssl", "password"})).toString();
    }
}

