/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModClusterRemoveMetric
implements OperationStepHandler,
DescriptionProvider {
    static final ModClusterRemoveMetric INSTANCE = new ModClusterRemoveMetric();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getRemoveMetricDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode dynamicLoadProvider = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("dynamic-load-provider");
                    String type = null;
                    if (dynamicLoadProvider.isDefined()) {
                        List list = operation.asPropertyList();
                        for (Property prop : list) {
                            if (!prop.getName().equals("type")) continue;
                            type = prop.getValue().asString();
                            break;
                        }
                        if (type != null) {
                            this.removeMetric(dynamicLoadProvider, type);
                        }
                        if (!dynamicLoadProvider.get("load-metric").isDefined() && !dynamicLoadProvider.get("custom-load-metric").isDefined()) {
                            context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().remove("dynamic-load-provider");
                        }
                    }
                    context.completeStep();
                }

                private void removeMetric(ModelNode dynamicLoadProvider, String type) {
                    List list = dynamicLoadProvider.get("load-metric").asList();
                    List newlist = Collections.emptyList();
                    dynamicLoadProvider.get("load-metric").set(newlist);
                    for (ModelNode node : list) {
                        if (node.get("type").asString().equals(type)) continue;
                        dynamicLoadProvider.get("load-metric").add(node);
                    }
                    list = dynamicLoadProvider.get("load-metric").asList();
                    if (list.isEmpty()) {
                        dynamicLoadProvider.remove("load-metric");
                    }
                }
            }, OperationContext.Stage.MODEL);
        }
        context.completeStep();
    }
}

