/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ConstantContextSelector;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientManagedTransactionContext;
import org.jboss.ejb.client.EJBClientUserTransactionContext;
import org.jboss.ejb.client.TransactionID;

public abstract class EJBClientTransactionContext
extends Attachable {
    private static volatile ContextSelector<EJBClientTransactionContext> SELECTOR = new ConstantContextSelector<EJBClientTransactionContext>(EJBClientTransactionContext.createLocal());
    private static final RuntimePermission SET_SELECTOR_PERMISSION = new RuntimePermission("setClientTransactionContextSelector");

    protected abstract TransactionID getAssociatedTransactionID(EJBClientInvocationContext var1) throws Exception;

    public static void setSelector(ContextSelector<EJBClientTransactionContext> selector) throws SecurityException {
        if (selector == null) {
            throw new IllegalArgumentException("selector is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        SELECTOR = selector;
    }

    public static void setGlobalContext(EJBClientTransactionContext context) throws SecurityException {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        EJBClientTransactionContext.setSelector(new ConstantContextSelector<EJBClientTransactionContext>(context));
    }

    public static EJBClientTransactionContext requireCurrent() throws IllegalStateException {
        EJBClientTransactionContext current = EJBClientTransactionContext.getCurrent();
        if (current == null) {
            throw new IllegalStateException("No transaction context available");
        }
        return current;
    }

    public static EJBClientTransactionContext getCurrent() {
        return SELECTOR.getCurrent();
    }

    public static EJBClientTransactionContext createLocal() {
        return EJBClientUserTransactionContext.INSTANCE;
    }

    public static EJBClientTransactionContext create(TransactionManager transactionManager, TransactionSynchronizationRegistry synchronizationRegistry) {
        return new EJBClientManagedTransactionContext(transactionManager, synchronizationRegistry);
    }

    protected UserTransaction getUserTransaction(String nodeName) {
        throw new IllegalStateException("User transactions not supported by this context");
    }
}

