/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.EJBClientManagedTransactionContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.XidTransactionID;

class RecoveryOnlyEJBXAResource
implements XAResource {
    private final EJBReceiverContext receiverContext;
    private final String transactionOriginNodeIdentifier;

    RecoveryOnlyEJBXAResource(String transactionOriginNodeIdentifier, EJBReceiverContext receiverContext) {
        this.receiverContext = receiverContext;
        this.transactionOriginNodeIdentifier = transactionOriginNodeIdentifier;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XidTransactionID transactionID = new XidTransactionID(xid);
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debug("Sending commit request for Xid " + xid + " to EJB receiver with node name " + receiver.getNodeName() + " during recovery. One phase? " + onePhase);
        receiver.sendCommit(this.receiverContext, transactionID, onePhase);
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        Logs.TXN.debug("Ignoring end request on XAResource " + this + " since this XAResource is only meant for transaction recovery");
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XidTransactionID transactionID = new XidTransactionID(xid);
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debug("Sending forget request for Xid " + xid + " to EJB receiver with node name " + receiver.getNodeName() + " during recovery");
        receiver.sendForget(this.receiverContext, transactionID);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        boolean toReturn = EJBClientManagedTransactionContext.isEJBXAResourceClass(xaResource.getClass().getName());
        if (toReturn && (toReturn = xaResource instanceof RecoveryOnlyEJBXAResource)) {
            EJBReceiver receiver = this.receiverContext.getReceiver();
            RecoveryOnlyEJBXAResource other = (RecoveryOnlyEJBXAResource)xaResource;
            EJBReceiver otherReceiver = other.receiverContext.getReceiver();
            toReturn = receiver.getNodeName().equals(otherReceiver.getNodeName());
        }
        return toReturn;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        Logs.TXN.debugf("Called prepare on recovery-only resource for xid %s", this, xid);
        throw new XAException(-3);
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debug("Send recover request for transaction origin node identifier " + this.transactionOriginNodeIdentifier + " to EJB receiver with node name " + receiver.getNodeName());
        return receiver.sendRecover(this.receiverContext, this.transactionOriginNodeIdentifier, flags);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XidTransactionID transactionID = new XidTransactionID(xid);
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debug("Sending rollback request for Xid " + xid + " to EJB receiver with node name " + receiver.getNodeName() + " during recovery");
        receiver.sendRollback(this.receiverContext, transactionID);
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        Logs.TXN.debug("Ignoring start request on XAResource " + this + " since this XAResource is only meant for transaction recovery");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RecoveryOnlyEJBXAResource");
        sb.append("{receiverContext=").append(this.receiverContext);
        sb.append(", transactionOriginNodeIdentifier='").append(this.transactionOriginNodeIdentifier).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

