/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.DefaultCallbackHandler;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.remoting.ClusterContextConnectionReconnectHandler;
import org.jboss.ejb.client.remoting.ClusterNode;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.ejb.client.remoting.RemotingConnectionManager;
import org.jboss.ejb.client.remoting.RemotingConnectionUtil;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class RemotingConnectionClusterNodeManager
implements ClusterNodeManager {
    private static final Logger logger = Logger.getLogger(RemotingConnectionClusterNodeManager.class);
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.EMPTY;
    private final ClusterContext clusterContext;
    private final ClusterNode clusterNode;
    private final Endpoint endpoint;
    private final EJBClientConfiguration ejbClientConfiguration;
    private final RemotingConnectionManager remotingConnectionManager = new RemotingConnectionManager();
    private final EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration;

    RemotingConnectionClusterNodeManager(ClusterContext clusterContext, ClusterNode clusterNode, Endpoint endpoint, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterContext = clusterContext;
        this.clusterNode = clusterNode;
        this.endpoint = endpoint;
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.connectionConfiguration = this.createConnectionConfiguration();
    }

    @Override
    public String getNodeName() {
        return this.clusterNode.getNodeName();
    }

    @Override
    public EJBReceiver getEJBReceiver() {
        if (!this.clusterNode.isDestinationResolved()) {
            Logs.REMOTING.cannotCreateEJBReceiverDueToUnknownTarget(this.clusterNode.toString());
            return null;
        }
        try {
            Connection connection = this.remotingConnectionManager.getConnection(this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), this.connectionConfiguration);
            int MAX_RECONNECT_ATTEMPTS = 65535;
            ClusterContextConnectionReconnectHandler reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), this.connectionConfiguration, 65535);
            return new RemotingConnectionEJBReceiver(connection, reconnectHandler, this.connectionConfiguration.getChannelCreationOptions());
        }
        catch (Exception e) {
            logger.info((Object)("Could not create a connection for cluster node " + this.clusterNode + " in cluster " + this.clusterContext.getClusterName()), (Throwable)e);
            return null;
        }
    }

    private EJBClientConfiguration.CommonConnectionCreationConfiguration createConnectionConfiguration() {
        ConnectionConfig connectionConfiguration;
        if (this.ejbClientConfiguration != null) {
            EJBClientConfiguration.ClusterConfiguration clusterConfiguration = this.ejbClientConfiguration.getClusterConfiguration(this.clusterContext.getClusterName());
            if (clusterConfiguration == null) {
                CallbackHandler callbackHandler = this.ejbClientConfiguration.getCallbackHandler();
                OptionMap connectionCreationOpts = RemotingConnectionUtil.addSilentLocalAuthOptionsIfApplicable(callbackHandler, DEFAULT_CONNECTION_CREATION_OPTIONS);
                connectionConfiguration = new ConnectionConfig(connectionCreationOpts, callbackHandler, 5000L, OptionMap.EMPTY);
            } else {
                EJBClientConfiguration.ClusterNodeConfiguration clusterNodeConfiguration = clusterConfiguration.getNodeConfiguration(this.getNodeName());
                OptionMap channelCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getChannelCreationOptions() : clusterNodeConfiguration.getChannelCreationOptions();
                CallbackHandler callbackHandler = clusterNodeConfiguration == null ? clusterConfiguration.getCallbackHandler() : clusterNodeConfiguration.getCallbackHandler();
                OptionMap connectionCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionCreationOptions() : clusterNodeConfiguration.getConnectionCreationOptions();
                connectionCreationOptions = RemotingConnectionUtil.addSilentLocalAuthOptionsIfApplicable(callbackHandler, connectionCreationOptions);
                long timeout = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionTimeout() : clusterNodeConfiguration.getConnectionTimeout();
                connectionConfiguration = new ConnectionConfig(connectionCreationOptions, callbackHandler, timeout, channelCreationOptions);
            }
        } else {
            DefaultCallbackHandler callbackHandler = new DefaultCallbackHandler();
            OptionMap connectionCreationOpts = RemotingConnectionUtil.addSilentLocalAuthOptionsIfApplicable(callbackHandler, DEFAULT_CONNECTION_CREATION_OPTIONS);
            connectionConfiguration = new ConnectionConfig(connectionCreationOpts, callbackHandler, 5000L, OptionMap.EMPTY);
        }
        return connectionConfiguration;
    }

    private class ConnectionConfig
    implements EJBClientConfiguration.CommonConnectionCreationConfiguration {
        private final long connectionTimeout;
        private final OptionMap connectionCreationOptions;
        private final OptionMap channelCreationOptions;
        private final CallbackHandler callbackHandler;

        ConnectionConfig(OptionMap connectionCreationOptions, CallbackHandler callbackHandler, long connectionTimeout, OptionMap channelCreationOptions) {
            this.callbackHandler = callbackHandler == null ? new DefaultCallbackHandler() : callbackHandler;
            this.connectionCreationOptions = connectionCreationOptions;
            this.channelCreationOptions = channelCreationOptions;
            this.connectionTimeout = connectionTimeout;
        }

        @Override
        public OptionMap getConnectionCreationOptions() {
            return this.connectionCreationOptions;
        }

        @Override
        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public OptionMap getChannelCreationOptions() {
            return this.channelCreationOptions;
        }

        @Override
        public boolean isConnectEagerly() {
            return false;
        }
    }
}

