/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.Transaction;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.NamingProvider;

public final class EJBClientInvocationContext
extends Attachable {
    private static final Logs log = Logs.MAIN;
    public static final String PRIVATE_ATTACHMENTS_KEY = "org.jboss.ejb.client.invocation.attachments";
    private static final EJBReceiverInvocationContext.ResultProducer.Immediate NULL_RESPONSE = new EJBReceiverInvocationContext.ResultProducer.Immediate(null);
    private final EJBInvocationHandler<?> invocationHandler;
    private final EJBClientContext ejbClientContext;
    private final Object invokedProxy;
    private final Object[] parameters;
    private final EJBProxyInformation.ProxyMethodInfo methodInfo;
    private final EJBReceiverInvocationContext receiverInvocationContext = new EJBReceiverInvocationContext(this);
    private final Object lock = new Object();
    private EJBReceiverInvocationContext.ResultProducer resultProducer;
    private EJBReceiver receiver;
    private EJBLocator<?> locator;
    private State state = State.WAITING;
    private AsyncState asyncState = AsyncState.SYNCHRONOUS;
    private Object cachedResult;
    private Map<String, Object> contextData;
    private int interceptorChainIndex;
    private boolean resultDone;
    private boolean blockingCaller;
    private Transaction transaction;
    private NamingProvider namingProvider;
    private Affinity weakAffinity = Affinity.NONE;
    static final Object PROCEED_ASYNC = new Object();

    EJBClientInvocationContext(EJBInvocationHandler<?> invocationHandler, EJBClientContext ejbClientContext, Object invokedProxy, Object[] parameters, EJBProxyInformation.ProxyMethodInfo methodInfo) {
        this.invocationHandler = invocationHandler;
        this.invokedProxy = invokedProxy;
        this.parameters = parameters;
        this.ejbClientContext = ejbClientContext;
        this.methodInfo = methodInfo;
        this.locator = invocationHandler.getLocator();
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    EJBInvocationHandler<?> getInvocationHandler() {
        return this.invocationHandler;
    }

    public EJBClientContext getClientContext() {
        return this.ejbClientContext;
    }

    public boolean isClientAsync() {
        return this.invocationHandler.isAsyncHandler() || this.methodInfo.isClientAsync();
    }

    public boolean isSynchronous() {
        return !this.isClientAsync() && this.methodInfo.isSynchronous();
    }

    public boolean isIdempotent() {
        return this.methodInfo.isIdempotent();
    }

    public ClientTransactionPolicy getTransactionPolicy() {
        return this.methodInfo.getTransactionPolicy();
    }

    public boolean isCompressRequest() {
        return this.methodInfo.isCompressRequest();
    }

    public boolean isCompressResponse() {
        return this.methodInfo.isCompressResponse();
    }

    public int getCompressionLevel() {
        return this.methodInfo.getCompressionLevel();
    }

    public String getMethodSignatureString() {
        return this.methodInfo.getSignature();
    }

    public EJBMethodLocator getMethodLocator() {
        return this.methodInfo.getMethodLocator();
    }

    public Map<String, Object> getContextData() {
        Map<String, Object> contextData = this.contextData;
        if (contextData == null) {
            this.contextData = new LinkedHashMap<String, Object>();
            return this.contextData;
        }
        return contextData;
    }

    public EJBLocator<?> getLocator() {
        return this.locator;
    }

    public <T> void setLocator(EJBLocator<T> locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockingCaller() {
        Object object = this.lock;
        synchronized (object) {
            return this.blockingCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockingCaller(boolean blockingCaller) {
        Object object = this.lock;
        synchronized (object) {
            this.blockingCaller = blockingCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() throws Exception {
        int idx = this.interceptorChainIndex++;
        try {
            EJBClientInterceptor[] chain = this.ejbClientContext.getInterceptors();
            if (idx > chain.length) {
                throw Logs.MAIN.sendRequestCalledDuringWrongPhase();
            }
            if (chain.length == idx) {
                EJBReceiver receiver = this.receiver;
                if (receiver == null) {
                    this.performInvocation(this.getLocator());
                } else {
                    receiver.processInvocation(this.receiverInvocationContext);
                }
            } else {
                chain[idx].handleInvocation(this);
            }
        }
        finally {
            --this.interceptorChainIndex;
        }
    }

    private <T> void performInvocation(EJBLocator<T> locator) throws Exception {
        this.ejbClientContext.performLocatedAction(locator, (receiver, originalLocator, newAffinity) -> {
            if (receiver == null) {
                throw Logs.MAIN.noEJBReceiverAvailable(this.getLocator());
            }
            receiver.processInvocation(this.receiverInvocationContext);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getResult() throws Exception {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (this.resultDone || resultProducer == null) {
            throw Logs.MAIN.getResultCalledDuringWrongPhase();
        }
        int idx = this.interceptorChainIndex++;
        EJBClientInterceptor[] chain = this.ejbClientContext.getInterceptors();
        if (chain.length == idx) {
            Object object = resultProducer.getResult();
            return object;
        }
        if (idx == 0) {
            Object object = chain[idx].handleInvocationResult(this);
            return object;
        }
        Object object = chain[idx].handleInvocationResult(this);
        this.resultDone = true;
        return object;
        catch (Throwable throwable) {
            this.resultDone = true;
            throw throwable;
        }
        {
            finally {
                this.resultDone = true;
                Affinity weakAffinity = this.getAttachment(AttachmentKeys.WEAK_AFFINITY);
                if (weakAffinity != null) {
                    this.invocationHandler.setWeakAffinity(weakAffinity);
                }
            }
        }
        finally {
            --this.interceptorChainIndex;
        }
    }

    public void discardResult() throws IllegalStateException {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (resultProducer == null) {
            throw Logs.MAIN.discardResultCalledDuringWrongPhase();
        }
        resultProducer.discardResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultReady(EJBReceiverInvocationContext.ResultProducer resultProducer) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.resultProducer = resultProducer;
                    this.state = State.READY;
                    this.lock.notifyAll();
                    return;
                }
            }
        }
        resultProducer.discardResult();
    }

    protected EJBReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(EJBReceiver receiver) {
        this.receiver = receiver;
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.methodInfo.getMethod();
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?> getViewClass() {
        return this.invocationHandler.getLocator().getViewType();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public Affinity getWeakAffinity() {
        return this.weakAffinity;
    }

    public void setWeakAffinity(Affinity weakAffinity) {
        Assert.checkNotNullParam((String)"weakAffinity", (Object)weakAffinity);
        this.weakAffinity = weakAffinity;
    }

    Future<?> getFutureResponse() {
        return new FutureResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void proceedAsynchronously() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncState == AsyncState.SYNCHRONOUS) {
                this.blockingCaller = false;
                this.asyncState = this.getInvokedMethod().getReturnType() == Void.TYPE ? AsyncState.ONE_WAY : AsyncState.ASYNCHRONOUS;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitCancellationResult() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            while (this.state != State.CANCELLED) {
                if (!this.state.isWaiting()) {
                    return false;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    Object awaitResponse(EJBInvocationHandler<?> invocationHandler) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiscardResult() {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncState != AsyncState.ONE_WAY) {
                this.asyncState = AsyncState.ONE_WAY;
                this.lock.notifyAll();
            }
            if (this.state == State.DONE) {
                return;
            }
            this.state = State.DISCARDED;
            resultProducer = this.resultProducer;
            this.lock.notifyAll();
        }
        if (resultProducer != null) {
            resultProducer.discardResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelled() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.state = State.CANCELLED;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Throwable exception) {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.state = State.FAILED;
                    this.cachedResult = exception;
                    this.lock.notifyAll();
                }
            }
        }
    }

    NamingProvider getNamingProvider() {
        return this.namingProvider;
    }

    void setNamingProvider(NamingProvider namingProvider) {
        this.namingProvider = namingProvider;
    }

    private class InvocationTimeoutResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final long timeout;

        InvocationTimeoutResultProducer(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public Object getResult() throws Exception {
            throw new TimeoutException("No invocation response received in " + this.timeout + " milliseconds");
        }

        @Override
        public void discardResult() {
        }
    }

    final class FutureResponse
    implements Future<Object> {
        FutureResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state != State.WAITING) {
                    return false;
                }
                EJBClientInvocationContext.this.state = State.CANCEL_REQ;
            }
            return EJBClientInvocationContext.this.getReceiver().cancelInvocation(EJBClientInvocationContext.this.receiverInvocationContext, mayInterruptIfRunning);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                return EJBClientInvocationContext.this.state == State.CANCELLED;
            }
        }

        @Override
        public boolean isDone() {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                switch (EJBClientInvocationContext.this.state) {
                    case WAITING: {
                        return false;
                    }
                    case CANCEL_REQ: 
                    case READY: 
                    case FAILED: 
                    case CANCELLED: 
                    case DONE: 
                    case CONSUMING: 
                    case DISCARDED: {
                        return true;
                    }
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get() throws InterruptedException, ExecutionException {
            Object result;
            EJBReceiverInvocationContext.ResultProducer resultProducer;
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                while (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING) {
                    EJBClientInvocationContext.this.lock.wait();
                }
                switch (EJBClientInvocationContext.this.state) {
                    case READY: {
                        EJBClientInvocationContext.this.state = State.CONSUMING;
                        resultProducer = EJBClientInvocationContext.this.resultProducer;
                        break;
                    }
                    case FAILED: {
                        throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.cachedResult);
                    }
                    case CANCELLED: {
                        throw log.requestCancelled();
                    }
                    case DONE: {
                        return EJBClientInvocationContext.this.cachedResult;
                    }
                    case DISCARDED: {
                        throw log.oneWayInvocation();
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            try {
                result = resultProducer.getResult();
            }
            catch (Exception e) {
                Object object2 = EJBClientInvocationContext.this.lock;
                synchronized (object2) {
                    assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                    EJBClientInvocationContext.this.state = State.FAILED;
                    EJBClientInvocationContext.this.cachedResult = e;
                    EJBClientInvocationContext.this.lock.notifyAll();
                }
                throw log.remoteInvFailed(e);
            }
            Object object3 = EJBClientInvocationContext.this.lock;
            synchronized (object3) {
                assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                EJBClientInvocationContext.this.state = State.DONE;
                EJBClientInvocationContext.this.cachedResult = result;
                EJBClientInvocationContext.this.lock.notifyAll();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object result;
            EJBReceiverInvocationContext.ResultProducer resultProducer;
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                block19: while (true) {
                    switch (EJBClientInvocationContext.this.state) {
                        case READY: {
                            EJBClientInvocationContext.this.state = State.CONSUMING;
                            resultProducer = EJBClientInvocationContext.this.resultProducer;
                            break block19;
                        }
                        case FAILED: {
                            throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.cachedResult);
                        }
                        case CANCELLED: {
                            throw log.requestCancelled();
                        }
                        case DONE: {
                            return EJBClientInvocationContext.this.cachedResult;
                        }
                        case DISCARDED: {
                            throw log.oneWayInvocation();
                        }
                        case WAITING: 
                        case CANCEL_REQ: 
                        case CONSUMING: {
                            long remaining = unit.toNanos(timeout);
                            if (remaining > 0L) {
                                long now = System.nanoTime();
                                do {
                                    EJBClientInvocationContext.this.lock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                                    if (EJBClientInvocationContext.this.state != State.WAITING && EJBClientInvocationContext.this.state != State.CANCEL_REQ && EJBClientInvocationContext.this.state != State.CONSUMING) continue block19;
                                } while ((remaining -= Math.max(1L, System.nanoTime() - now)) > 0L);
                            }
                            throw log.timedOut();
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
            }
            try {
                result = resultProducer.getResult();
            }
            catch (Exception e) {
                Object object2 = EJBClientInvocationContext.this.lock;
                synchronized (object2) {
                    assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                    EJBClientInvocationContext.this.state = State.FAILED;
                    EJBClientInvocationContext.this.cachedResult = e;
                    EJBClientInvocationContext.this.lock.notifyAll();
                }
                throw log.remoteInvFailed(e);
            }
            Object object3 = EJBClientInvocationContext.this.lock;
            synchronized (object3) {
                assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                EJBClientInvocationContext.this.state = State.DONE;
                EJBClientInvocationContext.this.cachedResult = result;
                EJBClientInvocationContext.this.lock.notifyAll();
            }
            return result;
        }
    }

    static enum State {
        WAITING(true),
        CANCEL_REQ(true),
        CANCELLED(false),
        READY(false),
        CONSUMING(false),
        FAILED(false),
        DONE(false),
        DISCARDED(false);

        private final boolean waiting;

        private State(boolean waiting) {
            this.waiting = waiting;
        }

        boolean isWaiting() {
            return this.waiting;
        }
    }

    static enum AsyncState {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        ONE_WAY;

    }
}

