/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.security.AccessController;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.CreateException;
import javax.net.ssl.SSLContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceRegistry;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemoteEJBReceiver
extends EJBReceiver {
    static final AttachmentKey<EJBClientChannel> EJBCC_KEY = new AttachmentKey();
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final RemoteTransportProvider remoteTransportProvider;
    private final EJBReceiverContext receiverContext;
    private final ServiceRegistry persistentClusterRegistry;
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<EJBClientChannel.ClusterDiscKey, ServiceRegistration>>> clusterRegistrationsMap;
    final ClientServiceHandle<EJBClientChannel> serviceHandle;
    final IoFuture.HandlingNotifier<ConnectionPeerIdentity, EJBReceiverInvocationContext> notifier = new IoFuture.HandlingNotifier<ConnectionPeerIdentity, EJBReceiverInvocationContext>(){

        public void handleDone(ConnectionPeerIdentity peerIdentity, EJBReceiverInvocationContext attachment) {
            EJBClientChannel ejbClientChannel;
            try {
                ejbClientChannel = RemoteEJBReceiver.this.getClientChannel(peerIdentity.getConnection());
            }
            catch (IOException e) {
                attachment.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(e, true)));
                return;
            }
            attachment.getClientInvocationContext().putAttachment(EJBCC_KEY, ejbClientChannel);
            ejbClientChannel.processInvocation(attachment, peerIdentity);
        }

        public void handleCancelled(EJBReceiverInvocationContext attachment) {
            attachment.requestCancelled();
        }

        public void handleFailed(IOException exception, EJBReceiverInvocationContext attachment) {
            attachment.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(exception, true)));
        }
    };

    RemoteEJBReceiver(RemoteTransportProvider remoteTransportProvider, EJBReceiverContext receiverContext, ServiceRegistry persistentClusterRegistry, ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<EJBClientChannel.ClusterDiscKey, ServiceRegistration>>> clusterRegistrationsMap) {
        this.remoteTransportProvider = remoteTransportProvider;
        this.receiverContext = receiverContext;
        this.persistentClusterRegistry = persistentClusterRegistry;
        this.clusterRegistrationsMap = clusterRegistrationsMap;
        this.serviceHandle = new ClientServiceHandle("jboss.ejb", channel -> EJBClientChannel.construct(channel, this.persistentClusterRegistry, this.clusterRegistrationsMap));
    }

    RemoteTransportProvider getRemoteTransportProvider() {
        return this.remoteTransportProvider;
    }

    EJBReceiverContext getReceiverContext() {
        return this.receiverContext;
    }

    EJBClientChannel getClientChannel(Connection connection) throws IOException {
        try {
            return (EJBClientChannel)this.serviceHandle.getClientService(connection, OptionMap.EMPTY).getInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        AuthenticationConfiguration authenticationConfiguration = receiverContext.getAuthenticationConfiguration();
        SSLContext sslContext = receiverContext.getSSLContext();
        IoFuture<ConnectionPeerIdentity> futureConnection = this.getConnection(locator, authenticationConfiguration, sslContext);
        futureConnection.addNotifier(this.notifier, (Object)receiverContext);
    }

    @Override
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        try {
            EJBClientChannel channel = receiverContext.getClientInvocationContext().getAttachment(EJBCC_KEY);
            return channel != null && channel.cancelInvocation(receiverContext, cancelIfRunning);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext) throws Exception {
        try {
            IoFuture<ConnectionPeerIdentity> futureConnection = this.getConnection(statelessLocator, authenticationConfiguration, sslContext);
            ConnectionPeerIdentity identity = (ConnectionPeerIdentity)futureConnection.getInterruptibly();
            EJBClientChannel ejbClientChannel = this.getClientChannel(identity.getConnection());
            return ejbClientChannel.openSession(statelessLocator, identity);
        }
        catch (IOException e) {
            CreateException createException = new CreateException("Failed to create stateful EJB: " + e.getMessage());
            createException.initCause((Throwable)e);
            throw createException;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CreateException("Stateful EJB creation interrupted");
        }
    }

    @Override
    protected boolean isConnected(URI uri) {
        IoFuture future = Endpoint.getCurrent().getConnectedIdentityIfExists(uri, "ejb", "jboss", AuthenticationContext.captureCurrent());
        try {
            return future != null && future.getStatus() == IoFuture.Status.DONE && ((ConnectionPeerIdentity)future.get()).getConnection().isOpen();
        }
        catch (IOException e) {
            throw Assert.unreachableCode();
        }
    }

    private <T> IoFuture<ConnectionPeerIdentity> getConnection(EJBLocator<T> locator, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext) throws Exception {
        Affinity affinity = locator.getAffinity();
        if (!(affinity instanceof URIAffinity)) {
            throw new IllegalArgumentException("Invalid EJB affinity");
        }
        URI target = affinity.getUri();
        if (authenticationConfiguration == null) {
            authenticationConfiguration = CLIENT.getAuthenticationConfiguration(target, AuthenticationContext.captureCurrent(), -1, "ejb", "jboss");
        }
        if (sslContext == null) {
            sslContext = CLIENT.getSSLContext(target, AuthenticationContext.captureCurrent(), "ejb", "jboss");
        }
        SSLContext finalSslContext = sslContext;
        AuthenticationConfiguration finalAuthenticationConfiguration = authenticationConfiguration;
        return AccessController.doPrivileged(() -> Endpoint.getCurrent().getConnectedIdentity(target, finalSslContext, finalAuthenticationConfiguration));
    }
}

