/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.security.AccessController;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.client.store.RelativeContext;
import org.wildfly.naming.client.util.FastHashtable;

class EJBRootContext
extends AbstractContext {
    private final Affinity affinity;
    private final NamingProvider namingProvider;

    EJBRootContext(NamingProvider namingProvider, FastHashtable<String, Object> env) {
        super(env);
        String scheme;
        URI providerUri;
        this.namingProvider = namingProvider;
        URI uRI = providerUri = namingProvider == null ? null : namingProvider.getProviderUri();
        this.affinity = providerUri == null ? Affinity.NONE : ((scheme = providerUri.getScheme()) == null ? Affinity.NONE : Affinity.forUri(providerUri));
    }

    protected Object lookupNative(Name name) throws NamingException {
        EJBLocator locator;
        Class<?> view;
        int cp;
        int size = name.size();
        if (size < 3) {
            return new RelativeContext(new FastHashtable((Map)this.getEnvironment()), (AbstractContext)this, SimpleName.of((Name)name));
        }
        if (size > 4) {
            throw EJBRootContext.nameNotFound((Name)name);
        }
        String appName = name.get(0);
        String moduleName = name.get(1);
        String lastPart = name.get(size - 1);
        String beanName = null;
        int i = 0;
        while (i < lastPart.length()) {
            cp = lastPart.codePointAt(i);
            if (cp == 33) {
                beanName = lastPart.substring(0, i);
                lastPart = lastPart.substring(i + 1);
                break;
            }
            if (cp == 63) {
                throw EJBRootContext.nameNotFound((Name)name);
            }
            i = lastPart.offsetByCodePoints(i, 1);
        }
        if (beanName == null) {
            if (size == 3) {
                return new RelativeContext(new FastHashtable((Map)this.getEnvironment()), (AbstractContext)this, SimpleName.of((Name)name));
            }
            throw EJBRootContext.nameNotFound((Name)name);
        }
        String distinctName = size == 4 ? name.get(2) : "";
        String viewType = null;
        int i2 = 0;
        while (i2 < lastPart.length()) {
            cp = lastPart.codePointAt(i2);
            if (cp == 63) {
                viewType = lastPart.substring(0, i2);
                lastPart = lastPart.substring(i2 + 1);
                break;
            }
            i2 = lastPart.offsetByCodePoints(i2, 1);
        }
        boolean stateful = false;
        if (viewType == null) {
            viewType = lastPart;
        } else {
            int eq = -1;
            int st = 0;
            int i3 = 0;
            while (i3 < lastPart.length()) {
                cp = lastPart.codePointAt(i3);
                if (cp == 61 && eq == -1) {
                    eq = i3;
                }
                if (cp == 38) {
                    if ("stateful".equals(lastPart.substring(st, eq == -1 ? i3 : eq)) && (eq == -1 || "true".equalsIgnoreCase(lastPart.substring(eq + 1, i3)))) {
                        stateful = true;
                    }
                    st = cp + 1;
                    eq = -1;
                }
                i3 = lastPart.offsetByCodePoints(i3, 1);
            }
            if ("stateful".equals(lastPart.substring(st, eq == -1 ? lastPart.length() : eq)) && (eq == -1 || "true".equalsIgnoreCase(lastPart.substring(eq + 1)))) {
                stateful = true;
            }
        }
        try {
            view = Class.forName(viewType, false, EJBRootContext.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw Logs.MAIN.lookupFailed(name, name, e);
        }
        if (stateful) {
            try {
                locator = EJBClient.createSession(this.affinity, view, appName, moduleName, beanName, distinctName);
            }
            catch (Exception e) {
                throw Logs.MAIN.lookupFailed(name, name, e);
            }
            if (locator == null) {
                throw Logs.MAIN.nullSessionCreated(name, name, this.affinity, new EJBIdentifier(appName, moduleName, beanName, distinctName));
            }
        } else {
            locator = this.createLocator(view, appName, moduleName, beanName, distinctName);
        }
        return EJBClient.createProxy(this.namingProvider, locator);
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm != null ? AccessController.doPrivileged(EJBRootContext::doGetContextClassLoader) : EJBRootContext.doGetContextClassLoader();
        return classLoader;
    }

    private static ClassLoader doGetContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private <T> StatelessEJBLocator<T> createLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) {
        return new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, distinctName, this.affinity);
    }

    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.lookupNative(name);
    }

    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        throw EJBRootContext.notSupported();
    }

    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        throw EJBRootContext.notSupported();
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }
}

