/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb._private;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SystemProperties {
    public static final String DESTINATION_RECHECK_INTERVAL = "org.jboss.ejb.client.destination-recheck-interval";
    public static final String DISCOVERY_ADDITIONAL_NODE_TIMEOUT = "org.jboss.ejb.client.discovery.additional-node-timeout";
    public static final String DISCOVERY_BLACKLIST_TIMEOUT = "org.jboss.ejb.client.discovery.blacklist.timeout";
    public static final String DISCOVERY_TIMEOUT = "org.jboss.ejb.client.discovery.timeout";
    public static final String EXPAND_PASSWORDS = "jboss-ejb-client.expandPasswords";
    public static final String JBOSS_NODE_NAME = "jboss.node.name";
    public static final String MAX_ENTRIES = "org.jboss.ejb.client.max-retries";
    public static final String PROPERTIES_FILE_PATH = "jboss.ejb.client.properties.file.path";
    public static final String QUIET_AUTH = "jboss.sasl.local-user.quiet-auth";
    public static final String USER_DIR = "user.dir";
    public static final String VIEW_ANNOTATION_SCAN_ENABLED = "org.jboss.ejb.client.view.annotation.scan.enabled";
    public static final String WILDFLY_TESTSUITE_HACK = "org.jboss.ejb.client.wildfly-testsuite-hack";

    private SystemProperties() {
    }

    public static boolean getBoolean(String propertyName) {
        return SystemProperties.getBoolean(propertyName, false);
    }

    public static boolean getBoolean(final String propertyName, final boolean defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Boolean.parseBoolean(System.getProperty(propertyName, String.valueOf(defaultValue)));
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty(propertyName, String.valueOf(defaultValue)));
            }
        });
    }

    public static int getInteger(final String propertyName, final int defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Integer.getInteger(propertyName, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(propertyName, defaultValue);
            }
        });
    }

    public static long getLong(final String propertyName, final long defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Long.getLong(propertyName, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong(propertyName, defaultValue);
            }
        });
    }

    public static String getString(String propertyName) {
        return SystemProperties.getString(propertyName, null);
    }

    public static String getString(final String propertyName, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(propertyName, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, defaultValue);
            }
        });
    }
}

