/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb._private.SystemProperties;
import org.wildfly.common.Assert;

public interface ClusterNodeSelector {
    public static final ClusterNodeSelector FIRST_AVAILABLE;
    public static final ClusterNodeSelector FIRST_CONNECTED;
    public static final ClusterNodeSelector RANDOM_CONNECTED;
    public static final ClusterNodeSelector RANDOM;
    public static final ClusterNodeSelector ROUND_ROBIN;
    public static final ClusterNodeSelector DEFAULT;
    public static final ClusterNodeSelector DEFAULT_PREFER_LOCAL;
    public static final ClusterNodeSelector RANDOM_PREFER_LOCAL;

    public String selectNode(String var1, String[] var2, String[] var3);

    public static ClusterNodeSelector simpleConnectionThresholdRandomSelector(int minimum) {
        return ClusterNodeSelector.minimumConnectionThreshold(minimum, RANDOM, ClusterNodeSelector.useRandomConnectedNode(ClusterNodeSelector.useRandomUnconnectedNode(FIRST_AVAILABLE)));
    }

    public static ClusterNodeSelector firstConnected(ClusterNodeSelector fallback) {
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return (clusterName, connectedNodes, totalAvailableNodes) -> connectedNodes.length > 0 ? connectedNodes[0] : fallback.selectNode(clusterName, connectedNodes, totalAvailableNodes);
    }

    public static ClusterNodeSelector useRandomConnectedNode(ClusterNodeSelector fallback) {
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return (clusterName, connectedNodes, totalAvailableNodes) -> {
            int length = connectedNodes.length;
            return length > 0 ? connectedNodes[ThreadLocalRandom.current().nextInt(length)] : fallback.selectNode(clusterName, connectedNodes, totalAvailableNodes);
        };
    }

    public static ClusterNodeSelector useRoundRobinConnectedNode(final ClusterNodeSelector fallback) {
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return new ClusterNodeSelector(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public String selectNode(String clusterName, String[] connectedNodes, String[] totalAvailableNodes) {
                return connectedNodes.length > 0 ? connectedNodes[Math.floorMod(this.count.getAndIncrement(), connectedNodes.length)] : fallback.selectNode(clusterName, connectedNodes, totalAvailableNodes);
            }
        };
    }

    public static ClusterNodeSelector minimumConnectionThreshold(int minimum, ClusterNodeSelector unmet, ClusterNodeSelector met) {
        return (clusterName, connectedNodes, totalAvailableNodes) -> (connectedNodes.length < minimum ? unmet : met).selectNode(clusterName, connectedNodes, totalAvailableNodes);
    }

    public static ClusterNodeSelector useRandomUnconnectedNode(ClusterNodeSelector fallback) {
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return (clusterName, connectedNodes, totalAvailableNodes) -> {
            if (connectedNodes.length == totalAvailableNodes.length) {
                return fallback.selectNode(clusterName, connectedNodes, totalAvailableNodes);
            }
            HashSet connected = new HashSet(connectedNodes.length);
            Collections.addAll(connected, connectedNodes);
            ArrayList available = new ArrayList(totalAvailableNodes.length);
            Collections.addAll(available, totalAvailableNodes);
            available.removeAll(connected);
            if (!6.$assertionsDisabled && available.isEmpty()) {
                throw new AssertionError();
            }
            return (String)available.get(ThreadLocalRandom.current().nextInt(available.size()));
        };
    }

    public static ClusterNodeSelector useRoundRobinUnconnectedNode(final ClusterNodeSelector fallback) {
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return new ClusterNodeSelector(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public String selectNode(String clusterName, String[] connectedNodes, String[] totalAvailableNodes) {
                if (connectedNodes.length == totalAvailableNodes.length) {
                    return fallback.selectNode(clusterName, connectedNodes, totalAvailableNodes);
                }
                HashSet connected = new HashSet(connectedNodes.length);
                Collections.addAll(connected, connectedNodes);
                ArrayList available = new ArrayList(totalAvailableNodes.length);
                Collections.addAll(available, totalAvailableNodes);
                available.removeAll(connected);
                assert (!available.isEmpty());
                return (String)available.get(Math.floorMod(this.count.getAndIncrement(), connectedNodes.length));
            }
        };
    }

    static {
        if (6.$assertionsDisabled) {
            // empty if block
        }
        FIRST_AVAILABLE = (clusterName, connectedNodes, totalAvailableNodes) -> totalAvailableNodes[0];
        FIRST_CONNECTED = ClusterNodeSelector.firstConnected(FIRST_AVAILABLE);
        RANDOM_CONNECTED = ClusterNodeSelector.useRandomConnectedNode(ClusterNodeSelector.useRandomUnconnectedNode(FIRST_AVAILABLE));
        RANDOM = (clusterName, connectedNodes, totalAvailableNodes) -> totalAvailableNodes[ThreadLocalRandom.current().nextInt(totalAvailableNodes.length)];
        ROUND_ROBIN = new ClusterNodeSelector(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public String selectNode(String clusterName, String[] connectedNodes, String[] totalAvailableNodes) {
                assert (totalAvailableNodes.length != 0);
                return totalAvailableNodes[Math.floorMod(this.count.getAndIncrement(), totalAvailableNodes.length)];
            }
        };
        DEFAULT = ClusterNodeSelector.simpleConnectionThresholdRandomSelector(5);
        DEFAULT_PREFER_LOCAL = new ClusterNodeSelector(){
            private final String localNodeName = SystemProperties.getString("jboss.node.name");

            @Override
            public String selectNode(String clusterName, String[] connectedNodes, String[] totalAvailableNodes) {
                if (totalAvailableNodes.length > 1 && this.localNodeName != null) {
                    for (String node : totalAvailableNodes) {
                        if (!this.localNodeName.equals(node)) continue;
                        if (Logs.MAIN.isDebugEnabled()) {
                            Logs.MAIN.debugf("Select local node %s for [cluster: %s]", this.localNodeName, clusterName);
                        }
                        return node;
                    }
                }
                return DEFAULT.selectNode(clusterName, connectedNodes, totalAvailableNodes);
            }
        };
        RANDOM_PREFER_LOCAL = new ClusterNodeSelector(){
            private final String localNodeName = SystemProperties.getString("jboss.node.name");

            @Override
            public String selectNode(String clusterName, String[] connectedNodes, String[] totalAvailableNodes) {
                if (totalAvailableNodes.length > 1 && this.localNodeName != null) {
                    for (String node : totalAvailableNodes) {
                        if (!this.localNodeName.equals(node)) continue;
                        if (Logs.MAIN.isDebugEnabled()) {
                            Logs.MAIN.debugf("Select local node %s for [cluster: %s]", this.localNodeName, clusterName);
                        }
                        return node;
                    }
                }
                return RANDOM.selectNode(clusterName, connectedNodes, totalAvailableNodes);
            }
        };
    }
}

