/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts.quartzdialects;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.jbpm.test.persistence.scripts.quartzdialects.DB2CustomDialect;
import org.jbpm.test.persistence.scripts.quartzdialects.MySQLCustomDialect;
import org.jbpm.test.persistence.scripts.quartzdialects.OracleCustomDialect;
import org.jbpm.test.persistence.scripts.quartzdialects.PostgreSQLCustomDialect;
import org.jbpm.test.persistence.scripts.quartzdialects.SQLServerCustomDialect;
import org.jbpm.test.persistence.scripts.quartzdialects.SybaseCustomDialect;

public class QuartzDialectResolver
implements DialectResolver {
    private static final long serialVersionUID = 1L;
    private static Map<String, Dialect> DIALECT_BY_NAME = new HashMap<String, Dialect>();

    public QuartzDialectResolver() {
        QuartzDialectResolver.registerDialect((Dialect)new MySQLCustomDialect(), "MySQL", "MariaDB");
        QuartzDialectResolver.registerDialect((Dialect)new DB2CustomDialect(), "DB2/LINUXX8664");
        QuartzDialectResolver.registerDialect((Dialect)new OracleCustomDialect(), "Oracle");
        QuartzDialectResolver.registerDialect((Dialect)new PostgreSQLCustomDialect(), "PostgreSQL", "EnterpriseDB");
        QuartzDialectResolver.registerDialect((Dialect)new SQLServerCustomDialect(), "Microsoft SQL Server");
        QuartzDialectResolver.registerDialect((Dialect)new SybaseCustomDialect(), "Adaptive Server Enterprise");
    }

    private static void registerDialect(Dialect dialect, String ... databaseNames) {
        Stream.of(databaseNames).forEach(x -> DIALECT_BY_NAME.put((String)x, dialect));
    }

    public Dialect resolveDialect(DialectResolutionInfo info) {
        return DIALECT_BY_NAME.get(info.getDatabaseName());
    }
}

