/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.scriptbuilder.ExitInsteadOfReturn;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.util.Utils;

public class ScriptBuilder
implements Statement,
AcceptsStatementVisitor {
    @VisibleForTesting
    List<Statement> statements = Lists.newArrayList();
    @VisibleForTesting
    Map<String, Map<String, String>> variableScopes = Maps.newLinkedHashMap();
    @VisibleForTesting
    List<String> variablesToUnset = Lists.newArrayList((Object[])new String[]{"PATH", "JAVA_HOME", "LIBRARY_PATH"});

    public ScriptBuilder addStatement(Statement statement) {
        this.statements.add((Statement)Preconditions.checkNotNull((Object)statement, (Object)"statement"));
        return this;
    }

    public ScriptBuilder unsetEnvironmentVariable(String name) {
        this.variablesToUnset.add((String)Preconditions.checkNotNull((Object)name, (Object)"name"));
        return this;
    }

    public ScriptBuilder addEnvironmentVariableScope(String scopeName, Map<String, String> variables) {
        this.variableScopes.put((String)Preconditions.checkNotNull((Object)scopeName, (Object)"scopeName"), (Map<String, String>)Preconditions.checkNotNull(variables, (Object)"variables"));
        return this;
    }

    public static Statement forget(String instanceName, String script, String logDir) {
        return new ExitInsteadOfReturn(Statements.forget(instanceName, script, logDir));
    }

    public static Statement findPid(String pid) {
        return new ExitInsteadOfReturn(Statements.findPid(pid));
    }

    public static Statement call(String fn, String ... args) {
        return new ExitInsteadOfReturn(Statements.call(fn, args));
    }

    @Override
    public String render(OsFamily osFamily) {
        LinkedHashMap functions = Maps.newLinkedHashMap();
        functions.put("abort", Utils.writeFunctionFromResource("abort", osFamily));
        for (Map.Entry<String, Map<String, String>> entry : this.variableScopes.entrySet()) {
            functions.put(entry.getKey(), Utils.writeFunction(entry.getKey(), Utils.writeVariableExporters(entry.getValue(), osFamily)));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ShellToken.BEGIN_SCRIPT.to(osFamily));
        builder.append(Utils.writeUnsetVariables(this.variablesToUnset, osFamily));
        Map<String, String> functionsToWrite = ScriptBuilder.resolveFunctionDependenciesForStatements(functions, this.statements, osFamily);
        ScriptBuilder.writeFunctions(functionsToWrite, osFamily, builder);
        builder.append(Utils.writeZeroPath(osFamily));
        StringBuilder statementBuilder = new StringBuilder();
        for (Statement statement : this.statements) {
            statementBuilder.append(statement.render(osFamily));
        }
        builder.append(statementBuilder.toString());
        builder.append(ShellToken.END_SCRIPT.to(osFamily));
        return builder.toString();
    }

    public static void writeFunctions(Map<String, String> functionsToWrite, OsFamily osFamily, StringBuilder builder) {
        if (functionsToWrite.size() > 0) {
            builder.append(ShellToken.BEGIN_FUNCTIONS.to(osFamily));
            for (String function : functionsToWrite.values()) {
                builder.append(Utils.replaceTokens(function, ShellToken.tokenValueMap(osFamily)));
            }
            builder.append(ShellToken.END_FUNCTIONS.to(osFamily));
        }
    }

    @VisibleForTesting
    public static Map<String, String> resolveFunctionDependenciesForStatements(Map<String, String> knownFunctions, Iterable<Statement> statements, final OsFamily osFamily) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(knownFunctions);
        ImmutableSet dependentFunctions = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(statements, (Function)new Function<Statement, Iterable<String>>(){

            public Iterable<String> apply(Statement from) {
                return from.functionDependencies(osFamily);
            }
        })));
        for (String unresolved : Sets.difference((Set)dependentFunctions, knownFunctions.keySet())) {
            builder.put((Object)unresolved, (Object)Utils.writeFunctionFromResource(unresolved, osFamily));
        }
        return builder.build();
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableSet.of();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        for (Statement statement : this.statements) {
            visitor.visit(statement);
        }
    }
}

