/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.util.Utils;

public class SwitchArg
implements Statement,
AcceptsStatementVisitor {
    private static final String INDENT = "   ";
    public static final Map<OsFamily, String> OS_TO_SWITCH_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"case ${arg} in\n", (Object)((Object)OsFamily.WINDOWS), (Object)"goto CASE_%{arg}\r\n");
    public static final Map<OsFamily, String> OS_TO_END_SWITCH_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"esac\n", (Object)((Object)OsFamily.WINDOWS), (Object)":END_SWITCH\r\n");
    public static final Map<OsFamily, String> OS_TO_CASE_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"{value})\n{action};;\n", (Object)((Object)OsFamily.WINDOWS), (Object)":CASE_{value}\r\n{action}GOTO END_SWITCH\r\n");
    private final int arg;
    private final Map<String, Statement> valueToActions;

    public SwitchArg(int arg, Map<String, Statement> valueToActions) {
        this.arg = arg;
        this.valueToActions = (Map)Preconditions.checkNotNull(valueToActions, (Object)"valueToActions");
    }

    @Override
    public String render(OsFamily family) {
        StringBuilder switchClause = new StringBuilder();
        this.addArgValidation(switchClause, family);
        switchClause.append(Utils.replaceTokens(OS_TO_SWITCH_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"arg", (Object)(this.arg + ""))));
        for (Map.Entry<String, Statement> entry : this.valueToActions.entrySet()) {
            StringBuilder actionBuilder = new StringBuilder();
            boolean shouldIndent = true;
            boolean inRunScript = false;
            boolean inCreateFile = false;
            for (String line : Splitter.on((String)ShellToken.LF.to(family)).split((CharSequence)entry.getValue().render(family))) {
                if (shouldIndent) {
                    actionBuilder.append(INDENT);
                }
                actionBuilder.append(line).append(ShellToken.LF.to(family));
                if (line.indexOf("END_OF_JCLOUDS_SCRIPT") != -1) {
                    boolean bl = inRunScript = !inRunScript;
                }
                if (line.indexOf("END_OF_JCLOUDS_FILE") != -1) {
                    inCreateFile = !inCreateFile;
                }
                shouldIndent = !inCreateFile && !inRunScript;
            }
            actionBuilder.delete(actionBuilder.lastIndexOf(ShellToken.LF.to(family)), actionBuilder.length());
            switchClause.append(Utils.replaceTokens(OS_TO_CASE_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"value", (Object)entry.getKey(), (Object)"action", (Object)actionBuilder.toString())));
        }
        switchClause.append(OS_TO_END_SWITCH_PATTERN.get((Object)family));
        return switchClause.toString();
    }

    @VisibleForTesting
    void addArgValidation(StringBuilder switchClause, OsFamily family) {
        if (family.equals((Object)OsFamily.WINDOWS)) {
            for (String value : this.valueToActions.keySet()) {
                switchClause.append("if not \"%").append(this.arg).append(String.format("\" == \"%s\" ", value));
            }
            switchClause.append("(\r\n   set EXCEPTION=bad argument: %").append(this.arg).append(" not in ");
            switchClause.append(Joiner.on((String)" ").join(this.valueToActions.keySet()));
            switchClause.append("\r\n   goto abort\r\n)\r\n");
        }
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        ArrayList functions = Lists.newArrayList();
        for (Statement statement : this.valueToActions.values()) {
            Iterables.addAll((Collection)functions, statement.functionDependencies(family));
        }
        return functions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.arg;
        result = 31 * result + (this.valueToActions == null ? 0 : ((Object)this.valueToActions).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwitchArg other = (SwitchArg)obj;
        if (this.arg != other.arg) {
            return false;
        }
        return !(this.valueToActions == null ? other.valueToActions != null : !((Object)this.valueToActions).equals(other.valueToActions));
    }

    @Override
    public void accept(StatementVisitor visitor) {
        for (Statement statement : this.valueToActions.values()) {
            visitor.visit(statement);
        }
    }
}

