/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.discovery.TestMethodResolver;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
class TestFactoryMethodResolver
extends TestMethodResolver {
    private static final IsTestFactoryMethod isTestFactoryMethod = new IsTestFactoryMethod();
    static final String SEGMENT_TYPE = "test-factory";

    TestFactoryMethodResolver() {
        super(SEGMENT_TYPE);
    }

    @Override
    protected boolean isTestMethod(Method candidate) {
        return isTestFactoryMethod.test(candidate);
    }

    @Override
    protected TestDescriptor resolveMethod(Method testMethod, ClassTestDescriptor parentClassDescriptor, UniqueId uniqueId) {
        return new TestFactoryTestDescriptor(uniqueId, parentClassDescriptor.getTestClass(), testMethod);
    }
}

