/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.DynamicContainerTestDescriptor;
import org.junit.jupiter.engine.descriptor.DynamicTestTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class TestFactoryTestDescriptor
extends TestMethodTestDescriptor {
    public static final String DYNAMIC_CONTAINER_SEGMENT_TYPE = "dynamic-container";
    public static final String DYNAMIC_TEST_SEGMENT_TYPE = "dynamic-test";
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();

    public TestFactoryTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId, testClass, testMethod);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean mayRegisterTests() {
        return true;
    }

    @Override
    protected void invokeTestMethod(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context.getExtensionContext();
        context.getThrowableCollector().execute(() -> {
            Object instance = extensionContext.getRequiredTestInstance();
            Object testFactoryMethodResult = executableInvoker.invoke(this.getTestMethod(), instance, extensionContext, context.getExtensionRegistry());
            TestSource source = (TestSource)this.getSource().orElseThrow(() -> new JUnitException("Illegal state: TestSource must be present"));
            try (Stream<DynamicNode> dynamicNodeStream = this.toDynamicNodeStream(testFactoryMethodResult);){
                int index = 1;
                Iterator iterator = dynamicNodeStream.iterator();
                while (iterator.hasNext()) {
                    DynamicNode dynamicNode = (DynamicNode)iterator.next();
                    JupiterTestDescriptor descriptor = TestFactoryTestDescriptor.createDynamicDescriptor(this, dynamicNode, index++, source);
                    dynamicTestExecutor.execute((TestDescriptor)descriptor);
                }
            }
            catch (ClassCastException ex) {
                throw this.invalidReturnTypeException(ex);
            }
        });
    }

    private Stream<DynamicNode> toDynamicNodeStream(Object testFactoryMethodResult) {
        try {
            return CollectionUtils.toStream((Object)testFactoryMethodResult);
        }
        catch (PreconditionViolationException ex) {
            throw this.invalidReturnTypeException(ex);
        }
    }

    static JupiterTestDescriptor createDynamicDescriptor(JupiterTestDescriptor parent, DynamicNode node, int index, TestSource source) {
        JupiterTestDescriptor descriptor;
        if (node instanceof DynamicTest) {
            DynamicTest test = (DynamicTest)node;
            UniqueId uniqueId = parent.getUniqueId().append(DYNAMIC_TEST_SEGMENT_TYPE, "#" + index);
            descriptor = new DynamicTestTestDescriptor(uniqueId, test, source);
        } else {
            DynamicContainer container = (DynamicContainer)node;
            UniqueId uniqueId = parent.getUniqueId().append(DYNAMIC_CONTAINER_SEGMENT_TYPE, "#" + index);
            descriptor = new DynamicContainerTestDescriptor(uniqueId, container, source);
        }
        parent.addChild((TestDescriptor)descriptor);
        return descriptor;
    }

    private JUnitException invalidReturnTypeException(Throwable cause) {
        String message = String.format("@TestFactory method [%s] must return a Stream, Collection, Iterable, or Iterator of %s.", this.getTestMethod().toGenericString(), DynamicNode.class.getName());
        return new JUnitException(message, cause);
    }
}

