/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ClasspathScanner;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(value=API.Usage.Internal)
public final class ReflectionUtils {
    private static final ClasspathScanner classpathScanner = new ClasspathScanner(ReflectionUtils::getDefaultClassLoader, ReflectionUtils::loadClass);
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap;

    private ReflectionUtils() {
    }

    public static ClassLoader getDefaultClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            return ClassLoader.getSystemClassLoader();
        }
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isAssignableTo(Object obj, Class<?> type) {
        Preconditions.notNull(type, "type must not be null");
        if (obj == null) {
            return !type.isPrimitive();
        }
        if (type.isInstance(obj)) {
            return true;
        }
        if (type.isPrimitive()) {
            return primitiveToWrapperMap.get(type) == obj.getClass();
        }
        return false;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        return primitiveToWrapperMap.get(type);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Preconditions.notNull(clazz, "class must not be null");
        Preconditions.notNull(args, "none of the arguments may be null");
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            return ReflectionUtils.newInstance(clazz.getDeclaredConstructor(parameterTypes), args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        Preconditions.notNull(constructor, "constructor must not be null");
        try {
            return ReflectionUtils.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        Preconditions.notNull(method, "method must not be null");
        Preconditions.condition(target != null || ReflectionUtils.isStatic(method), () -> String.format("Cannot invoke non-static method [%s] on a null target.", method.toGenericString()));
        try {
            return ReflectionUtils.makeAccessible(method).invoke(target, args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Optional<Class<?>> loadClass(String name) {
        return ReflectionUtils.loadClass(name, ReflectionUtils.getDefaultClassLoader());
    }

    public static Optional<Class<?>> loadClass(String name, ClassLoader classLoader) {
        Preconditions.notBlank(name, "class name must not be null or blank");
        Preconditions.notNull(classLoader, "ClassLoader must not be null");
        try {
            return Optional.of(classLoader.loadClass(name.trim()));
        }
        catch (ClassNotFoundException ignore) {
            return Optional.empty();
        }
    }

    public static Optional<Method> loadMethod(String fullyQualifiedMethodName) {
        Preconditions.notBlank(fullyQualifiedMethodName, "fully qualified method name must not be null or blank");
        fullyQualifiedMethodName = fullyQualifiedMethodName.trim();
        int hashPosition = fullyQualifiedMethodName.lastIndexOf(35);
        if (hashPosition >= 0 && hashPosition < fullyQualifiedMethodName.length()) {
            Optional<Class<?>> classOptional;
            String className = fullyQualifiedMethodName.substring(0, hashPosition);
            String methodName = fullyQualifiedMethodName.substring(hashPosition + 1);
            if (StringUtils.isNotBlank(className) && StringUtils.isNotBlank(methodName) && (classOptional = ReflectionUtils.loadClass(className)).isPresent()) {
                try {
                    return Optional.of(classOptional.get().getDeclaredMethod(methodName, new Class[0]));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    private static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(field -> field.getName().startsWith("this$")).findFirst().map(field -> {
            try {
                return ReflectionUtils.makeAccessible(field).get(inner);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException ignore) {
                return Optional.empty();
            }
        });
    }

    public static Optional<Object> getOuterInstance(Object inner, Class<?> targetType) {
        Preconditions.notNull(inner, "inner object must not be null");
        Preconditions.notNull(targetType, "targetType must not be null");
        if (targetType.isInstance(inner)) {
            return Optional.of(inner);
        }
        Optional<Object> candidate = ReflectionUtils.getOuterInstance(inner);
        if (candidate.isPresent()) {
            return ReflectionUtils.getOuterInstance(candidate.get(), targetType);
        }
        return Optional.empty();
    }

    public static boolean isPackage(String packageName) {
        return classpathScanner.isPackage(packageName);
    }

    public static Set<File> getAllClasspathRootDirectories() {
        String fullClassPath = System.getProperty("java.class.path");
        return Arrays.stream(fullClassPath.split(File.pathSeparator)).filter(part -> !part.endsWith(".jar")).map(File::new).filter(File::isDirectory).collect(Collectors.toSet());
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(File root, Predicate<Class<?>> classTester) {
        return classpathScanner.scanForClassesInClasspathRoot(root, classTester);
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classTester) {
        return classpathScanner.scanForClassesInPackage(basePackageName, classTester);
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "predicate must not be null");
        return Arrays.stream(clazz.getDeclaredClasses()).filter(predicate).collect(Collectors.toList());
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        try {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Preconditions.condition(constructors.length == 1, () -> String.format("Class [%s] must declare a single constructor", clazz.getName()));
            return constructors[0];
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Optional<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "method name must not be null or empty");
        try {
            return Optional.ofNullable(clazz.getMethod(methodName, parameterTypes));
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "method name must not be null or empty");
        Predicate<Method> nameAndParameterTypesMatch = method -> method.getName().equals(methodName) && Arrays.equals(method.getParameterTypes(), parameterTypes);
        List<Method> candidates = ReflectionUtils.findMethods(clazz, nameAndParameterTypesMatch);
        return !candidates.isEmpty() ? Optional.of(candidates.get(0)) : Optional.empty();
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionUtils.findMethods(clazz, predicate, MethodSortOrder.HierarchyDown);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "predicate must not be null");
        Preconditions.notNull(sortOrder, "MethodSortOrder must not be null");
        return ReflectionUtils.findAllMethodsInHierarchy(clazz, sortOrder).stream().filter(predicate).collect(Collectors.toList());
    }

    private static List<Method> findAllMethodsInHierarchy(Class<?> clazz, MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(sortOrder, "MethodSortOrder must not be null");
        List<Method> localMethods = Arrays.asList(clazz.getDeclaredMethods());
        List superclassMethods = ReflectionUtils.getSuperclassMethods(clazz, sortOrder).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        List interfaceMethods = ReflectionUtils.getInterfaceMethods(clazz, sortOrder).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        ArrayList<Method> methods = new ArrayList<Method>();
        if (sortOrder == MethodSortOrder.HierarchyDown) {
            methods.addAll(superclassMethods);
            methods.addAll(interfaceMethods);
        }
        methods.addAll(localMethods);
        if (sortOrder == MethodSortOrder.HierarchyUp) {
            methods.addAll(interfaceMethods);
            methods.addAll(superclassMethods);
        }
        return methods;
    }

    public static <T> Optional<Object> readFieldValue(Class<T> clazz, String fieldName, T instance) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(fieldName, "fieldName must not be null or empty");
        try {
            Field field = ReflectionUtils.makeAccessible(clazz.getDeclaredField(fieldName));
            return Optional.ofNullable(field.get(instance));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return Optional.empty();
        }
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz, MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(sortOrder, "MethodSortOrder must not be null");
        ArrayList<Method> allInterfaceMethods = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List localMethods = Arrays.stream(ifc.getDeclaredMethods()).filter(Method::isDefault).collect(Collectors.toList());
            List subInterfaceMethods = ReflectionUtils.getInterfaceMethods(ifc, sortOrder).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
            if (sortOrder == MethodSortOrder.HierarchyDown) {
                allInterfaceMethods.addAll(subInterfaceMethods);
            }
            allInterfaceMethods.addAll(localMethods);
            if (sortOrder != MethodSortOrder.HierarchyUp) continue;
            allInterfaceMethods.addAll(subInterfaceMethods);
        }
        return allInterfaceMethods;
    }

    private static List<Method> getSuperclassMethods(Class<?> clazz, MethodSortOrder sortOrder) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findAllMethodsInHierarchy(superclass, sortOrder);
    }

    private static boolean isMethodShadowedByLocalMethods(Method method, List<Method> localMethods) {
        return localMethods.stream().anyMatch(local -> ReflectionUtils.isMethodShadowedBy(method, local));
    }

    private static boolean isMethodShadowedBy(Method upper, Method lower) {
        if (!lower.getName().equals(upper.getName())) {
            return false;
        }
        return Arrays.equals(lower.getParameterTypes(), upper.getParameterTypes());
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    private static Throwable getUnderlyingCause(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ReflectionUtils.getUnderlyingCause(((InvocationTargetException)t).getTargetException());
        }
        return t;
    }

    public static Set<Class<?>> getAllAssignmentCompatibleClasses(Class<?> clazz) {
        Preconditions.notNull(clazz, "class must not be null");
        LinkedHashSet result = new LinkedHashSet();
        ReflectionUtils.getAllAssignmentCompatibleClasses(clazz, result);
        return result;
    }

    private static void getAllAssignmentCompatibleClasses(Class<?> clazz, Set<Class<?>> result) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.add(current);
            for (Class<?> interfaceClass : current.getInterfaces()) {
                if (result.contains(interfaceClass)) continue;
                ReflectionUtils.getAllAssignmentCompatibleClasses(interfaceClass, result);
            }
        }
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> map = new HashMap<Class<Comparable<Boolean>>, Class>(8);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        primitiveToWrapperMap = Collections.unmodifiableMap(map);
    }

    public static enum MethodSortOrder {
        HierarchyDown,
        HierarchyUp;

    }
}

