/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
public interface TestDescriptor {
    public UniqueId getUniqueId();

    public String getDisplayName();

    public Set<TestTag> getTags();

    public Optional<TestSource> getSource();

    public Optional<TestDescriptor> getParent();

    public void setParent(TestDescriptor var1);

    public Set<? extends TestDescriptor> getChildren();

    default public Set<? extends TestDescriptor> getAllDescendants() {
        LinkedHashSet<TestDescriptor> all = new LinkedHashSet<TestDescriptor>();
        all.addAll(this.getChildren());
        for (TestDescriptor testDescriptor : this.getChildren()) {
            all.addAll(testDescriptor.getAllDescendants());
        }
        return all;
    }

    public void addChild(TestDescriptor var1);

    public void removeChild(TestDescriptor var1);

    public void removeFromHierarchy();

    default public boolean isRoot() {
        return !this.getParent().isPresent();
    }

    public boolean isContainer();

    public boolean isTest();

    default public boolean hasTests() {
        return this.isTest() || this.getChildren().stream().anyMatch(TestDescriptor::hasTests);
    }

    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId var1);

    default public void accept(Visitor visitor) {
        visitor.visit(this);
        new LinkedHashSet<TestDescriptor>(this.getChildren()).forEach(child -> child.accept(visitor));
    }

    public static interface Visitor {
        public void visit(TestDescriptor var1);
    }
}

