/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.math.BigDecimal;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.DefaultParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfigurationStrategy;

@API(status=API.Status.EXPERIMENTAL, since="1.3")
public enum DefaultParallelExecutionConfigurationStrategy implements ParallelExecutionConfigurationStrategy
{
    FIXED{

        @Override
        public ParallelExecutionConfiguration createConfiguration(ConfigurationParameters configurationParameters) {
            int parallelism = configurationParameters.get(DefaultParallelExecutionConfigurationStrategy.CONFIG_FIXED_PARALLELISM_PROPERTY_NAME, Integer::valueOf).orElseThrow(() -> new JUnitException("fixed.parallelism must be set"));
            return new DefaultParallelExecutionConfiguration(parallelism, parallelism, 256 + parallelism, parallelism, 30);
        }
    }
    ,
    DYNAMIC{

        @Override
        public ParallelExecutionConfiguration createConfiguration(ConfigurationParameters configurationParameters) {
            BigDecimal factor = configurationParameters.get(DefaultParallelExecutionConfigurationStrategy.CONFIG_DYNAMIC_FACTOR_PROPERTY_NAME, BigDecimal::new).orElse(BigDecimal.ONE);
            Preconditions.condition((factor.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, () -> "dynamic.factor must be greater than 0");
            int parallelism = Math.max(1, factor.multiply(BigDecimal.valueOf(Runtime.getRuntime().availableProcessors())).intValue());
            return new DefaultParallelExecutionConfiguration(parallelism, parallelism, 256 + parallelism, parallelism, 30);
        }
    }
    ,
    CUSTOM{

        @Override
        public ParallelExecutionConfiguration createConfiguration(ConfigurationParameters configurationParameters) {
            String className = configurationParameters.get(DefaultParallelExecutionConfigurationStrategy.CONFIG_CUSTOM_CLASS_PROPERTY_NAME).orElseThrow(() -> new JUnitException("custom.class must be set"));
            Class strategyClass = (Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new JUnitException("Could not load class for custom.class"));
            Preconditions.condition((boolean)ParallelExecutionConfigurationStrategy.class.isAssignableFrom(strategyClass), (String)("custom.class does not implement " + ParallelExecutionConfigurationStrategy.class));
            ParallelExecutionConfigurationStrategy strategy = (ParallelExecutionConfigurationStrategy)ReflectionUtils.newInstance((Class)strategyClass, (Object[])new Object[0]);
            return strategy.createConfiguration(configurationParameters);
        }
    };

    public static final String CONFIG_STRATEGY_PROPERTY_NAME = "strategy";
    public static final String CONFIG_FIXED_PARALLELISM_PROPERTY_NAME = "fixed.parallelism";
    public static final String CONFIG_DYNAMIC_FACTOR_PROPERTY_NAME = "dynamic.factor";
    @API(status=API.Status.EXPERIMENTAL, since="5.3")
    public static final String CONFIG_CUSTOM_CLASS_PROPERTY_NAME = "custom.class";

    static ParallelExecutionConfigurationStrategy getStrategy(ConfigurationParameters configurationParameters) {
        return DefaultParallelExecutionConfigurationStrategy.valueOf(configurationParameters.get(CONFIG_STRATEGY_PROPERTY_NAME).orElse("dynamic").toUpperCase());
    }
}

