/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.admin.client.resource.ClientTemplatesResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;

public interface RealmResource {
    @GET
    @Produces(value={"application/json"})
    public RealmRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(RealmRepresentation var1);

    @Path(value="clients")
    public ClientsResource clients();

    @Path(value="client-templates")
    public ClientTemplatesResource clientTemplates();

    @Path(value="client-description-converter")
    @POST
    @Consumes(value={"application/json", "application/xml", "text/plain"})
    @Produces(value={"application/json"})
    public ClientRepresentation convertClientDescription(String var1);

    @Path(value="users")
    public UsersResource users();

    @Path(value="roles")
    public RolesResource roles();

    @Path(value="groups")
    public GroupsResource groups();

    @GET
    @Path(value="group-by-path/{path: .*}")
    @NoCache
    @Produces(value={"application/json"})
    public GroupRepresentation getGroupByPath(@PathParam(value="path") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="default-groups")
    public List<GroupRepresentation> getDefaultGroups();

    @PUT
    @Path(value="default-groups/{groupId}")
    public void addDefaultGroup(@PathParam(value="groupId") String var1);

    @DELETE
    @Path(value="default-groups/{groupId}")
    public void removeDefaultGroup(@PathParam(value="groupId") String var1);

    @Path(value="identity-provider")
    public IdentityProvidersResource identityProviders();

    @DELETE
    public void remove();

    @Path(value="client-session-stats")
    @GET
    public List<Map<String, String>> getClientSessionStats();

    @Path(value="clients-initial-access")
    public ClientInitialAccessResource clientInitialAccess();
}

