/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import java.net.URI;
import org.apache.http.client.methods.RequestBuilder;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.HttpMethod;

public class Http {
    private final Configuration configuration;
    private final ClientAuthenticator authenticator;
    private ServerConfiguration serverConfiguration;

    public Http(Configuration configuration, ClientAuthenticator authenticator) {
        this.configuration = configuration;
        this.authenticator = authenticator;
    }

    public <R> HttpMethod<R> get(String path) {
        return this.method(RequestBuilder.get().setUri(this.serverConfiguration.getIssuer() + path));
    }

    public <R> HttpMethod<R> get(URI path) {
        return this.method(RequestBuilder.get().setUri(path));
    }

    public <R> HttpMethod<R> post(URI path) {
        return this.method(RequestBuilder.post().setUri(path));
    }

    public <R> HttpMethod<R> post(String path) {
        return this.method(RequestBuilder.post().setUri(this.serverConfiguration.getIssuer() + path));
    }

    public <R> HttpMethod<R> put(String path) {
        return this.method(RequestBuilder.put().setUri(this.serverConfiguration.getIssuer() + path));
    }

    public <R> HttpMethod<R> delete(String path) {
        return this.method(RequestBuilder.delete().setUri(this.serverConfiguration.getIssuer() + path));
    }

    private <R> HttpMethod<R> method(RequestBuilder builder) {
        return new HttpMethod(this.configuration, this.authenticator, builder);
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }
}

