/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.ApplicationRoleEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.jpa.entities.UserScopeMappingEntity;

public class ApplicationAdapter
implements ApplicationModel {
    protected EntityManager em;
    protected ApplicationEntity application;
    protected RealmModel realm;

    public ApplicationAdapter(RealmModel realm, EntityManager em, ApplicationEntity application) {
        this.realm = realm;
        this.em = em;
        this.application = application;
    }

    public void updateApplication() {
        this.em.flush();
    }

    public UserModel getApplicationUser() {
        return new UserAdapter(this.application.getApplicationUser());
    }

    public String getId() {
        return this.application.getId();
    }

    public String getName() {
        return this.application.getName();
    }

    public void setName(String name) {
        this.application.setName(name);
    }

    public boolean isEnabled() {
        return this.application.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.application.setEnabled(enabled);
    }

    public boolean isSurrogateAuthRequired() {
        return this.application.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.application.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.application.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.application.setManagementUrl(url);
    }

    public String getBaseUrl() {
        return this.application.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.application.setBaseUrl(url);
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getAppRoleByName", ApplicationRoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("application", (Object)this.application);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this.realm, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        RoleModel role = this.getRole(name);
        if (role != null) {
            return role;
        }
        ApplicationRoleEntity entity = new ApplicationRoleEntity();
        entity.setName(name);
        entity.setApplication(this.application);
        this.em.persist((Object)entity);
        this.application.getRoles().add(entity);
        this.em.flush();
        return new RoleAdapter(this.realm, this.em, entity);
    }

    public boolean removeRoleById(String id) {
        ApplicationRoleEntity role = (ApplicationRoleEntity)this.em.find(ApplicationRoleEntity.class, (Object)id);
        if (role == null) {
            return false;
        }
        this.application.getRoles().remove(role);
        this.application.getDefaultRoles().remove(role);
        this.em.createQuery("delete from " + UserScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + UserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        role.setApplication(null);
        this.em.flush();
        this.em.remove((Object)role);
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<ApplicationRoleEntity> roles = this.application.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity roleEntity : roles) {
            list.add(new RoleAdapter(this.realm, this.em, roleEntity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        return this.realm.getRoleById(id);
    }

    public Set<RoleModel> getApplicationRoleMappings(UserModel user) {
        Set roleMappings = this.realm.getRoleMappings(user);
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ApplicationModel app;
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel || !(app = (ApplicationModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getApplicationScopeMappings(UserModel user) {
        Set roleMappings = this.realm.getScopeMappings(user);
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ApplicationModel app;
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel || !(app = (ApplicationModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.application.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.application.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        entities.add(((RoleAdapter)role).getRole());
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.application.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!ApplicationAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }

    public void addScope(RoleModel role) {
        this.realm.addScopeMapping(this.getApplicationUser(), role);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationAdapter)) {
            return false;
        }
        ApplicationAdapter app = (ApplicationAdapter)o;
        return app.getId().equals(this.getId());
    }

    public String toString() {
        return this.getName();
    }
}

